/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.network;

import com.lclc98.checklist.world.ChecklistWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TaskMessage {
    public String task;
    public boolean toggle;

    public TaskMessage() {
    }

    public TaskMessage(String task, boolean toggle) {
        this.task = task;
        this.toggle = toggle;
    }

    public static void encode(TaskMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.task);
        buf.writeBoolean(message.toggle);
    }

    public static TaskMessage decode(PacketBuffer buf) {
        String task = buf.func_150789_c(Short.MAX_VALUE);
        boolean toggle = buf.readBoolean();
        return new TaskMessage(task, toggle);
    }

    public static void handle(TaskMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        UUID uuid = player.func_110124_au();
        ChecklistWorldSavedData savedData = ChecklistWorldSavedData.get(player.field_70170_p);
        List data = savedData.getTasks().getOrDefault(uuid, new ArrayList());
        if (message.toggle) {
            data.add(message.task);
        } else {
            data.remove(message.task);
        }
        savedData.getTasks().put(uuid, data);
        savedData.func_76185_a();
    }
}

