/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.lclc98.checklist.loader.ChecklistConfig;
import com.lclc98.checklist.loader.markdown.LinkElementMarkdown;
import com.lclc98.checklist.loader.markdown.LinkMarkdown;
import com.lclc98.checklist.loader.markdown.Markdown;
import com.lclc98.checklist.loader.markdown.NewPageMarkdown;
import com.lclc98.checklist.loader.markdown.StringMarkdown;
import com.lclc98.checklist.loader.markdown.TitleMarkdown;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ChecklistLoader {
    public static ChecklistConfig CONFIG = new ChecklistConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final List<Markdown> TASKS = new LinkedList<Markdown>();
    private static final Path TASK_FILE = Paths.get("config/checklist/tasks.txt", new String[0]);
    private static final Path CONFIG_FILE = Paths.get("config/checklist/config.json", new String[0]);
    private static final Pattern LINK_REGEX = Pattern.compile("\\[([^\\[]+)]\\((.*?)\\)", 2);

    public static void init() {
        BufferedWriter writer;
        if (!Files.exists(TASK_FILE, new LinkOption[0])) {
            try {
                Files.createDirectories(TASK_FILE.getParent(), new FileAttribute[0]);
                Files.createFile(TASK_FILE, new FileAttribute[0]);
                writer = Files.newBufferedWriter(TASK_FILE, new OpenOption[0]);
                try {
                    writer.write("#Example Title\nTask 1\nTask 2");
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
                    CONFIG = (ChecklistConfig)GSON.fromJson((Reader)reader, ChecklistConfig.class);
                }
            } else {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
                Files.createFile(CONFIG_FILE, new FileAttribute[0]);
            }
            writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);
            try {
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ChecklistLoader.reload();
    }

    public static void reload() {
        TASKS.clear();
        try (BufferedReader reader = Files.newBufferedReader(TASK_FILE);){
            reader.lines().forEach(s -> {
                String text = s.trim();
                if (text.length() > 0) {
                    Matcher matcher = LINK_REGEX.matcher(text);
                    ArrayList<LinkElementMarkdown> matches = new ArrayList<LinkElementMarkdown>();
                    int negativeOffset = 0;
                    while (matcher.find()) {
                        String linkText = matcher.group(1);
                        String link = matcher.group(2);
                        int a = matcher.start() - negativeOffset;
                        String before = text.substring(0, a);
                        text = before + linkText + text.substring(a + matcher.group().length());
                        int count = StringUtils.countMatches((CharSequence)before, (CharSequence)"\\n");
                        matches.add(new LinkElementMarkdown(linkText, link, a - count));
                        negativeOffset += matcher.group().length() - linkText.length();
                    }
                    if (!matches.isEmpty()) {
                        TASKS.add(new LinkMarkdown(text, matches.toArray(new LinkElementMarkdown[0])));
                    } else if (text.equals("===")) {
                        TASKS.add(new NewPageMarkdown());
                    } else if (text.startsWith("#")) {
                        TASKS.add(new TitleMarkdown(text.substring(1)));
                    } else {
                        TASKS.add(new StringMarkdown(text));
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

