/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.client.gui.element;

import com.lclc98.checklist.client.gui.ScreenUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskElement {
    protected final String text;
    protected float centerX;
    protected float leftX;
    protected float y;
    protected int page;

    public TaskElement(String text) {
        this.text = text;
    }

    public void init(float centerX, float leftX, float heightOffset, int page) {
        this.centerX = centerX;
        this.leftX = leftX;
        this.page = page;
        this.y = (int)Math.floor(heightOffset);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.wrapString(matrixStack, fontRenderer, this.centerX, 139, true);
    }

    public void wrapString(MatrixStack matrixStack, FontRenderer fontRenderer, float x, int length, boolean center) {
        List<IReorderingProcessor> f = ScreenUtil.splitText(fontRenderer, this.text, length);
        Objects.requireNonNull(fontRenderer);
        float dy = this.y + 9.0f / 2.0f + 1.0f;
        float f2 = (float)f.size() - 1.0f;
        Objects.requireNonNull(fontRenderer);
        dy -= f2 * 9.0f / 2.0f;
        for (IReorderingProcessor s : f) {
            fontRenderer.func_238422_b_(matrixStack, s, x - (center ? (float)fontRenderer.func_243245_a(s) / 2.0f : 0.0f), dy, 0);
            Objects.requireNonNull(fontRenderer);
            dy += 9.0f;
        }
    }

    public String getText() {
        return this.text;
    }

    public int getPage() {
        return this.page;
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
    }
}

