/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.client.gui.element;

import com.lclc98.checklist.Checklist;
import com.lclc98.checklist.client.gui.ScreenUtil;
import com.lclc98.checklist.client.gui.TaskBookScreen;
import com.lclc98.checklist.client.gui.element.LinkElement;
import com.lclc98.checklist.client.gui.element.TaskElement;
import com.lclc98.checklist.loader.markdown.LinkElementMarkdown;
import com.lclc98.checklist.loader.markdown.LinkMarkdown;
import com.lclc98.checklist.network.AchievementUnlockMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LinkTaskElement
extends TaskElement {
    private final LinkMarkdown markdown;
    private final List<LinkElement> linkElements = new ArrayList<LinkElement>();

    public LinkTaskElement(LinkMarkdown markdown) {
        super(markdown.getText());
        this.markdown = markdown;
    }

    @Override
    public void init(float centerX, float leftX, float heightOffset, int page) {
        super.init(centerX, leftX, heightOffset, page);
        this.linkElements.clear();
        for (LinkElementMarkdown elementMarkdown : this.markdown.getLinkElements()) {
            elementMarkdown.setInit(false);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List<ITextProperties> q = ScreenUtil.split(fontRenderer, this.text, 139);
        Objects.requireNonNull(fontRenderer);
        float dy = this.y + 9.0f / 2.0f;
        float f = (float)q.size() - 1.0f;
        Objects.requireNonNull(fontRenderer);
        dy -= f * 9.0f / 2.0f;
        StringBuilder builder = new StringBuilder();
        for (ITextProperties iTextProperties : q) {
            String lineText = iTextProperties.getString();
            for (LinkElementMarkdown linkElement : this.markdown.getLinkElements()) {
                if (linkElement.isInit() || builder.length() + lineText.length() < linkElement.getOffset()) continue;
                int aaaa = Math.max(linkElement.getOffset() - builder.length(), 0);
                float linkX = centerX - (float)fontRenderer.func_78256_a(lineText) / 2.0f + (float)fontRenderer.func_78256_a(lineText.substring(0, aaaa));
                float linkWidth = fontRenderer.func_78256_a(linkElement.getText().length() > lineText.length() ? lineText : linkElement.getText());
                float linkY = dy;
                Objects.requireNonNull(fontRenderer);
                float linkHeight = 9.0f;
                this.linkElements.add(new LinkElement(linkX, linkY, linkWidth, linkHeight, linkElement.getLink()));
                linkElement.setInit(builder.length() + lineText.length() >= linkElement.getOffset() + linkElement.getText().length());
            }
            builder.append(lineText);
            builder.append(" ");
            Objects.requireNonNull(fontRenderer);
            dy += 9.0f;
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (LinkElement linkElement : this.linkElements) {
                if (!(mouseX > (double)linkElement.getLinkX()) || !(mouseX < (double)(linkElement.getLinkX() + linkElement.getLinkWidth())) || !(mouseY >= (double)linkElement.getLinkY()) || !(mouseY <= (double)(linkElement.getLinkY() + linkElement.getLinkHeight()))) continue;
                Minecraft minecraft = Minecraft.func_71410_x();
                minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(confirmed -> {
                    if (confirmed) {
                        Util.func_110647_a().func_195640_a(linkElement.getLink());
                        Checklist.NETWORK.sendToServer((Object)new AchievementUnlockMessage(linkElement.getLink()));
                    }
                    minecraft.func_147108_a((Screen)new TaskBookScreen());
                }, linkElement.getLink(), true));
                break;
            }
        }
    }
}

