/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.client.gui;

import com.lclc98.checklist.client.gui.ScreenUtil;
import com.lclc98.checklist.client.gui.element.CheckboxTaskElement;
import com.lclc98.checklist.client.gui.element.LinkTaskElement;
import com.lclc98.checklist.client.gui.element.NewPageElement;
import com.lclc98.checklist.client.gui.element.TaskElement;
import com.lclc98.checklist.loader.ChecklistLoader;
import com.lclc98.checklist.loader.markdown.LinkMarkdown;
import com.lclc98.checklist.loader.markdown.Markdown;
import com.lclc98.checklist.loader.markdown.NewPageMarkdown;
import com.lclc98.checklist.loader.markdown.TitleMarkdown;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskBookScreen
extends Screen {
    private static final ResourceLocation BOOK_GUI_TEXTURES = new ResourceLocation("textures/gui/book.png");
    private static final int BOOK_WIDTH = 192;
    private static final int BOOK_HEIGHT = 192;
    private static int currPage;
    public static final List<String> COMPLETED_TASKS;
    private final List<TaskElement> bookElements = new ArrayList<TaskElement>();
    private int bookTotalPages = 1;
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonPreviousPage;

    public TaskBookScreen() {
        super(NarratorChatListener.field_216868_a);
        for (Markdown task : ChecklistLoader.TASKS) {
            if (task instanceof TitleMarkdown) {
                this.bookElements.add(new TaskElement(task.getText()));
                continue;
            }
            if (task instanceof LinkMarkdown) {
                this.bookElements.add(new LinkTaskElement((LinkMarkdown)task));
                continue;
            }
            if (task instanceof NewPageMarkdown) {
                this.bookElements.add(new NewPageElement());
                continue;
            }
            this.bookElements.add(new CheckboxTaskElement(task.getText()));
        }
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        float halfWidth = (float)this.field_230708_k_ / 2.0f;
        float center = -83.5f;
        float leftPageCenterX = halfWidth + -83.5f;
        float leftPageLeftX = halfWidth - 10.0f - 139.0f + 1.0f - 6.0f;
        float rightPageCenterX = halfWidth - -83.5f;
        float rightPageLeftX = halfWidth + 10.0f + 6.0f;
        int nextX = (int)Math.floor(halfWidth + 10.0f + 139.0f + 1.0f - 6.0f);
        int prevX = (int)Math.floor(leftPageLeftX);
        this.buttonNextPage = (ButtonNextPage)this.func_230480_a_((Widget)new ButtonNextPage(nextX - 23, 195, true, p -> {
            if (currPage < this.bookTotalPages - 1) {
                ++currPage;
            }
            this.updateButtons();
        }));
        this.buttonPreviousPage = (ButtonNextPage)this.func_230480_a_((Widget)new ButtonNextPage(prevX + 23, 195, false, p -> {
            if (currPage > 0) {
                --currPage;
            }
            this.updateButtons();
        }));
        int page = 0;
        boolean leftPage = true;
        float heightOffset = 10.0f;
        for (TaskElement element : this.bookElements) {
            if (element instanceof NewPageElement) {
                heightOffset = 10.0f;
                if (leftPage) {
                    leftPage = false;
                    continue;
                }
                leftPage = true;
                ++page;
                continue;
            }
            float stringHeight = ScreenUtil.getStringHeight(this.field_230712_o_, element);
            if (stringHeight + heightOffset > 180.0f) {
                heightOffset = 10.0f;
                if (leftPage) {
                    leftPage = false;
                } else {
                    leftPage = true;
                    ++page;
                }
            }
            if (leftPage) {
                element.init(leftPageCenterX, leftPageLeftX, heightOffset + stringHeight / 2.0f, page);
            } else {
                element.init(rightPageCenterX, rightPageLeftX, heightOffset + stringHeight / 2.0f, page);
            }
            Objects.requireNonNull(this.field_230712_o_);
            heightOffset += stringHeight + 9.0f * 1.25f;
        }
        this.bookTotalPages = page + 1;
        if (currPage > this.bookTotalPages) {
            currPage = this.bookTotalPages - 1;
        }
        this.updateButtons();
    }

    public void func_231164_f_() {
        Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_230694_p_ = currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_230694_p_ = currPage > 0;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
        float u = 21.0f;
        int halfWidth = this.field_230708_k_ / 2;
        int bWidth = 232;
        int bHeight = 232;
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)halfWidth, (int)2, (int)232, (int)232, (float)20.0f, (float)0.0f, (int)192, (int)192, (int)256, (int)256);
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(halfWidth - 232), (int)2, (int)232, (int)232, (float)213.0f, (float)0.0f, (int)-192, (int)192, (int)256, (int)256);
        for (TaskElement element : this.bookElements) {
            if (element.getPage() != currPage) continue;
            element.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (TaskElement element : this.bookElements) {
            if (element.getPage() != currPage) continue;
            element.mouseClicked(mouseX, mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    static {
        COMPLETED_TASKS = new ArrayList<String>();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ButtonNextPage
    extends Button {
        private final boolean isForward;

        public ButtonNextPage(int x, int y, boolean isForwardIn, Button.IPressable pressable) {
            super(x, y, 23, 13, NarratorChatListener.field_216868_a, pressable);
            this.isForward = isForwardIn;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
            int i = 0;
            int j = 192;
            if (this.field_230692_n_) {
                i += 23;
            }
            if (!this.isForward) {
                j += 13;
            }
            this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, i, j, 23, 13);
        }
    }
}

