/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.crt;

import com.blamejared.crafttweaker.CraftTweaker;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class CrTSidedExecutor {
    @Nullable
    public static <T> T callOnSide(LogicalSide side, Supplier<Callable<T>> toRun) {
        return side.isClient() ? CrTSidedExecutor.callForSide(toRun, null) : CrTSidedExecutor.callForSide(null, toRun);
    }

    @Nullable
    public static <T> T callForSide(@Nullable Supplier<Callable<T>> client, @Nullable Supplier<Callable<T>> server) {
        try {
            if (CrTSidedExecutor.getLogicalSide().isClient() && client != null) {
                return client.get().call();
            }
            if (CrTSidedExecutor.getLogicalSide().isServer() && server != null) {
                return server.get().call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void runOnSide(LogicalSide side, Supplier<Runnable> toRun) {
        if (side.isClient()) {
            CrTSidedExecutor.runForSide(toRun, null);
        } else if (side.isServer()) {
            CrTSidedExecutor.runForSide(null, toRun);
        }
    }

    public static void runForSide(@Nullable Supplier<Runnable> client, @Nullable Supplier<Runnable> server) {
        try {
            if (CrTSidedExecutor.getLogicalSide().isClient() && client != null) {
                client.get().run();
            } else if (CrTSidedExecutor.getLogicalSide().isServer() && server != null) {
                server.get().run();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void runOnClient(Runnable toRun) {
        CrTSidedExecutor.runOnSide(LogicalSide.CLIENT, () -> toRun);
    }

    public static void runOnServer(Runnable toRun) {
        CrTSidedExecutor.runOnSide(LogicalSide.SERVER, () -> toRun);
    }

    public static LogicalSide getLogicalSide() {
        if (CraftTweaker.serverOverride || FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return LogicalSide.SERVER;
        }
        return EffectiveSide.get();
    }
}

