/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import java.util.Collection;
import java.util.function.Supplier;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.CropSerializer;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.fertilizer.FertilizerSerializer;
import net.darkhax.botanypots.soil.SoilInfo;
import net.darkhax.botanypots.soil.SoilSerializer;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Content {
    public final IRecipeType<SoilInfo> recipeTypeSoil;
    public final IRecipeSerializer<?> recipeSerializerSoil;
    public final IRecipeType<CropInfo> recipeTypeCrop;
    public final IRecipeSerializer<?> recipeSerializerCrop;
    public final IRecipeType<FertilizerInfo> recipeTypeFertilizer;
    public final IRecipeSerializer<?> recipeSerializerFertilizer;
    public final TileEntityType<TileEntityBotanyPot> tileBotanyPot;
    public final Block basicBotanyPot;
    public final Block hopperBotanyPot;

    public Content(RegistryHelper registry) {
        this.recipeTypeSoil = registry.recipeTypes.register("soil");
        this.recipeSerializerSoil = (IRecipeSerializer)registry.recipeSerializers.register((IForgeRegistryEntry)SoilSerializer.INSTANCE, "soil");
        this.recipeTypeCrop = registry.recipeTypes.register("crop");
        this.recipeSerializerCrop = (IRecipeSerializer)registry.recipeSerializers.register((IForgeRegistryEntry)CropSerializer.INSTANCE, "crop");
        this.recipeTypeFertilizer = registry.recipeTypes.register("fertilizer");
        this.recipeSerializerFertilizer = (IRecipeSerializer)registry.recipeSerializers.register((IForgeRegistryEntry)FertilizerSerializer.INSTANCE, "fertilizer");
        this.basicBotanyPot = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockBotanyPot(), "botany_pot");
        this.hopperBotanyPot = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockBotanyPot(true), "hopper_botany_pot");
        for (DyeColor dyeColor : DyeColor.values()) {
            registry.blocks.register((IForgeRegistryEntry)new BlockBotanyPot(), dyeColor.func_176610_l() + "_botany_pot");
            registry.blocks.register((IForgeRegistryEntry)new BlockBotanyPot(true), "hopper_" + dyeColor.func_176610_l() + "_botany_pot");
        }
        this.tileBotanyPot = Content.register("botany_pot", TileEntityBotanyPot::new, BlockBotanyPot.botanyPots);
        registry.tileEntities.register(this.tileBotanyPot, "botany_pot");
    }

    @Deprecated
    private static <T extends TileEntity> TileEntityType<T> register(String key, Supplier<? extends T> factoryIn, Collection<Block> validBlocks) {
        Type type = Util.func_240976_a_((DSL.TypeReference)TypeReferences.field_211294_j, (String)key);
        TileEntityType.Builder builder = TileEntityType.Builder.func_223042_a(factoryIn, (Block[])validBlocks.toArray(new Block[0]));
        return builder.func_206865_a(type);
    }
}

