/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.screen.ChunkGridCell;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;

public class ChunkGrid
extends BaseWidget {
    private static final ResourceLocation GRID_OVERLAY = new ResourceLocation("chunkloaders", "textures/gui/grid_overlay.png");
    private final int rows;
    private final int columns;
    private final ChunkPos topLeftChunk;
    private final UUID player;
    private final int loaderYLevel;
    private final List<ChunkGridCell> cells = new ArrayList<ChunkGridCell>();
    private final boolean[][] loadedChunks;
    private final boolean[][] withinRangeChunks;
    private final boolean[][] loadedChunksForOtherPlayers;
    private boolean doDrag = false;
    private boolean dragState = false;
    private final List<ChunkGridCell> draggedButtons = new ArrayList<ChunkGridCell>();

    public ChunkGrid(int x, int y, int rows, int columns, ChunkPos topLeftChunk, UUID player, int loaderYLevel) {
        super(x, y, columns * 18 + 2, rows * 18 + 2);
        this.rows = rows;
        this.columns = columns;
        this.topLeftChunk = topLeftChunk;
        this.player = player;
        this.loaderYLevel = loaderYLevel;
        this.loadedChunks = new boolean[rows][columns];
        this.withinRangeChunks = new boolean[rows][columns];
        this.loadedChunksForOtherPlayers = new boolean[rows][columns];
        this.update();
    }

    protected void addWidgets() {
        for (int row = 0; row < this.rows; ++row) {
            int column = 0;
            while (column < this.columns) {
                int cellX = this.x + 1 + column * 18;
                int cellY = this.y + 1 + row * 18;
                ChunkPos pos = new ChunkPos(this.topLeftChunk.field_77276_a + column, this.topLeftChunk.field_77275_b + row);
                int finalRow = row;
                int finalColumn = column++;
                this.addWidget(new ChunkGridCell(cellX, cellY, pos, this.loaderYLevel, this.player, (hOffset, vOffset) -> this.isChunkLoaded(finalRow + vOffset, finalColumn + hOffset), (hOffset, vOffset) -> this.isChunkWithinRange(finalRow + vOffset, finalColumn + hOffset), (hOffset, vOffset) -> this.isChunkLoadedByOtherPlayer(finalRow + vOffset, finalColumn + hOffset)));
            }
        }
    }

    protected <T extends Widget> T addWidget(T widget) {
        if (widget instanceof ChunkGridCell) {
            this.cells.add((ChunkGridCell)widget);
        }
        return (T)super.addWidget(widget);
    }

    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY) {
        ScreenUtils.fillRect((MatrixStack)poseStack, (float)(this.x + 1), (float)this.y, (float)(this.width - 2), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ScreenUtils.fillRect((MatrixStack)poseStack, (float)this.x, (float)(this.y + 1), (float)this.width, (float)(this.height - 2), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ScreenUtils.fillRect((MatrixStack)poseStack, (float)(this.x + 1), (float)(this.y + this.height - 1), (float)(this.width - 2), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ScreenUtils.bindTexture((ResourceLocation)GRID_OVERLAY);
        ScreenUtils.drawTexture((MatrixStack)poseStack, (float)(this.x + 1), (float)(this.y + 1), (float)(this.width - 2), (float)(this.height - 2), (float)0.0f, (float)0.0f, (float)this.columns, (float)this.rows);
        super.renderBackground(poseStack, mouseX, mouseY);
    }

    public ITextComponent getNarrationMessage() {
        return null;
    }

    public void update() {
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                ChunkPos pos = new ChunkPos(this.topLeftChunk.field_77276_a + column, this.topLeftChunk.field_77275_b + row);
                ChunkLoadingCapability capability = ChunkLoadingCapability.get(ClientUtils.getWorld());
                this.loadedChunks[row][column] = capability.isChunkLoadedByPlayer(this.player, pos);
                this.withinRangeChunks[row][column] = capability.canPlayerLoadChunk(this.player, pos);
                Set<UUID> activePlayers = capability.getActivePlayersLoadingChunk(pos);
                if (activePlayers.contains(this.player) ? activePlayers.size() > 1 : !activePlayers.isEmpty()) {
                    this.loadedChunksForOtherPlayers[row][column] = true;
                    continue;
                }
                Set<UUID> inactivePlayers = capability.getInactivePlayersLoadingChunk(pos);
                this.loadedChunksForOtherPlayers[row][column] = inactivePlayers.contains(this.player) ? inactivePlayers.size() > 1 : !inactivePlayers.isEmpty();
            }
        }
        super.update();
    }

    private boolean isChunkLoaded(int row, int column) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            return false;
        }
        return this.loadedChunks[row][column];
    }

    private boolean isChunkWithinRange(int row, int column) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            return false;
        }
        return this.withinRangeChunks[row][column] && !this.loadedChunks[row][column];
    }

    private boolean isChunkLoadedByOtherPlayer(int row, int column) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            return false;
        }
        return this.loadedChunksForOtherPlayers[row][column];
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (button == 0) {
            for (ChunkGridCell cell : this.cells) {
                if (!cell.isFocused()) continue;
                this.doDrag = true;
                this.dragState = !cell.isLoaded();
                this.draggedButtons.clear();
                this.draggedButtons.add(cell);
                cell.onPress();
                return true;
            }
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (button == 0) {
            this.doDrag = false;
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }

    public void render(MatrixStack poseStack, int mouseX, int mouseY) {
        super.render(poseStack, mouseX, mouseY);
        if (this.doDrag) {
            for (ChunkGridCell cell : this.cells) {
                if (!cell.isFocused() || cell.isLoaded() == this.dragState || this.draggedButtons.contains((Object)cell)) continue;
                cell.onPress();
                this.draggedButtons.add(cell);
            }
        }
    }
}

