/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class PacketToggleChunk
implements BasePacket {
    private UUID owner;
    private ChunkPos pos;

    public PacketToggleChunk(UUID owner, ChunkPos pos) {
        this.owner = owner;
        this.pos = pos;
    }

    public PacketToggleChunk() {
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179252_a(this.owner);
        buffer.writeLong(this.pos.func_201841_a());
    }

    public void read(PacketBuffer buffer) {
        this.owner = buffer.func_179253_g();
        this.pos = new ChunkPos(buffer.readLong());
    }

    public void handle(PacketContext context) {
        ServerPlayerEntity player = (ServerPlayerEntity)context.getSendingPlayer();
        if (!this.owner.equals(player.func_110124_au()) && !player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH())) {
            return;
        }
        ServerChunkLoadingCapability capability = ChunkLoadingCapability.get((World)player.func_71121_q()).castServer();
        if (capability.isChunkLoadedByPlayer(this.owner, this.pos)) {
            capability.stopLoadingChunk(this.owner, this.pos);
        } else if (capability.canPlayerLoadChunk(this.owner, this.pos)) {
            capability.startLoadingChunk(this.owner, this.pos);
        }
    }
}

