/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.TextComponents;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class PlayerActivityTracker {
    private static final Set<UUID> activePlayers = new LinkedHashSet<UUID>();
    private static final Set<UUID> onlinePlayers = new LinkedHashSet<UUID>();
    private static final Map<UUID, ActiveTime> lastActiveTimePerPlayer = new HashMap<UUID, ActiveTime>();
    private static final SortedSet<ActiveTime> sortedActiveTimes = new TreeSet<ActiveTime>();
    private static boolean dirty = false;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ActiveTime lastActiveTime;
        UUID playerId = e.getPlayer().func_110124_au();
        onlinePlayers.add(playerId);
        if (!activePlayers.contains(playerId)) {
            activePlayers.add(playerId);
            if (PlayerActivityTracker.isInactivityTimeOutEnabled()) {
                boolean sendMessage = false;
                for (ServerWorld level : e.getPlayer().func_184102_h().func_212370_w()) {
                    sendMessage |= ChunkLoadingCapability.get((World)level).castServer().togglePlayerActivity(playerId, true);
                }
                if (sendMessage) {
                    PlayerActivityTracker.sendInactivityNotification(e.getPlayer());
                }
            }
        }
        if ((lastActiveTime = lastActiveTimePerPlayer.remove(playerId)) != null) {
            sortedActiveTimes.remove(lastActiveTime);
        }
        dirty = true;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        UUID playerId = e.getPlayer().func_110124_au();
        onlinePlayers.remove(playerId);
        ActiveTime lastActiveTime = new ActiveTime(playerId, System.currentTimeMillis());
        lastActiveTimePerPlayer.put(playerId, lastActiveTime);
        sortedActiveTimes.add(lastActiveTime);
        dirty = true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        long timeoutTime = System.currentTimeMillis() - PlayerActivityTracker.getInactivityTimeout();
        while (!sortedActiveTimes.isEmpty()) {
            ActiveTime earliestExpiringTime = sortedActiveTimes.first();
            if (earliestExpiringTime.lastActiveTime >= timeoutTime) break;
            sortedActiveTimes.remove(earliestExpiringTime);
            lastActiveTimePerPlayer.remove(earliestExpiringTime.player);
            activePlayers.remove(earliestExpiringTime.player);
            dirty = true;
            ActiveTime finalEarliestExpiringTime = earliestExpiringTime;
            if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) continue;
            ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(level -> ChunkLoadingCapability.get((World)level).castServer().togglePlayerActivity(finalEarliestExpiringTime.player, false));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerAboutToStartEvent e) {
        activePlayers.clear();
        onlinePlayers.clear();
        lastActiveTimePerPlayer.clear();
        sortedActiveTimes.clear();
        dirty = false;
        File file = new File(e.getServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "chunkloaders/active_players.nbt");
        if (!file.exists()) {
            return;
        }
        try {
            CompoundNBT data = CompressedStreamTools.func_74797_a((File)file);
            if (data != null) {
                PlayerActivityTracker.read(data);
            }
        }
        catch (IOException exception) {
            ChunkLoaders.LOGGER.error("Failed to load player activity data!", (Throwable)exception);
        }
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        if (!(e.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (dirty) {
            CompoundNBT data = PlayerActivityTracker.write();
            File file = new File(((ServerWorld)e.getWorld()).func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile(), "chunkloaders/active_players.nbt");
            file.getParentFile().mkdirs();
            try {
                CompressedStreamTools.func_74795_b((CompoundNBT)data, (File)file);
            }
            catch (IOException exception) {
                ChunkLoaders.LOGGER.error("Failed to write active player data!", (Throwable)exception);
                return;
            }
            dirty = false;
        }
    }

    public static boolean isPlayerActive(UUID player) {
        return !PlayerActivityTracker.isInactivityTimeOutEnabled() || activePlayers.contains(player);
    }

    private static boolean isInactivityTimeOutEnabled() {
        return ChunkLoadersConfig.inactivityTimeout.get() > 0L;
    }

    private static long getInactivityTimeout() {
        return ChunkLoadersConfig.inactivityTimeout.get() * 60L * 1000L;
    }

    private static void sendInactivityNotification(PlayerEntity player) {
        if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) {
            return;
        }
        long timeout = ChunkLoadersConfig.inactivityTimeout.get();
        int days = (int)(timeout / 1440L);
        int hours = (int)(timeout / 60L % 24L);
        int minutes = (int)(timeout % 60L);
        TextComponents.TextComponentBuilder timeoutText = null;
        if (days > 0) {
            timeoutText = TextComponents.translation((String)"chunkloaders.inactivity.days", (Object[])new Object[]{days}).color(TextFormatting.GOLD);
        }
        if (hours > 0) {
            TextComponents.TextComponentBuilder textComponentBuilder = timeoutText = timeoutText == null ? TextComponents.translation((String)"chunkloaders.inactivity.hours", (Object[])new Object[]{hours}).color(TextFormatting.GOLD) : timeoutText.string(" ").translation("chunkloaders.inactivity.hours", new Object[]{hours}).color(TextFormatting.GOLD);
        }
        if (minutes > 0) {
            TextComponents.TextComponentBuilder textComponentBuilder = timeoutText = timeoutText == null ? TextComponents.translation((String)"chunkloaders.inactivity.minutes", (Object[])new Object[]{minutes}).color(TextFormatting.GOLD) : timeoutText.string(" ").translation("chunkloaders.inactivity.minutes", new Object[]{minutes}).color(TextFormatting.GOLD);
        }
        if (timeoutText == null) {
            throw new AssertionError((Object)"Timeout must be greater than 0!");
        }
        IFormattableTextComponent header = TextComponents.translation((String)"chunkloaders.inactivity.header").color(TextFormatting.GOLD).get();
        player.func_145747_a((ITextComponent)TextComponents.translation((String)"chunkloaders.inactivity.notification", (Object[])new Object[]{header, timeoutText.get()}).get(), Util.field_240973_b_);
    }

    private static CompoundNBT write() {
        CompoundNBT tag;
        ListNBT activeTimes = new ListNBT();
        for (UUID player : onlinePlayers) {
            tag = new CompoundNBT();
            tag.func_186854_a("player", player);
            tag.func_74772_a("time", System.currentTimeMillis());
            activeTimes.add((Object)tag);
        }
        for (ActiveTime activeTime : lastActiveTimePerPlayer.values()) {
            tag = new CompoundNBT();
            tag.func_186854_a("player", activeTime.player);
            tag.func_74772_a("time", activeTime.lastActiveTime);
            activeTimes.add((Object)tag);
        }
        CompoundNBT tag2 = new CompoundNBT();
        tag2.func_218657_a("times", (INBT)activeTimes);
        return tag2;
    }

    private static void read(CompoundNBT tag) {
        ListNBT activeTimes = tag.func_150295_c("times", 10);
        for (INBT nbt : activeTimes) {
            CompoundNBT timeTag;
            if (!(nbt instanceof CompoundNBT) || !(timeTag = (CompoundNBT)nbt).func_150297_b("player", 11) || !timeTag.func_150297_b("time", 4)) continue;
            ActiveTime activeTime = new ActiveTime(timeTag.func_186857_a("player"), timeTag.func_74763_f("time"));
            activePlayers.add(activeTime.player);
            sortedActiveTimes.add(activeTime);
            lastActiveTimePerPlayer.put(activeTime.player, activeTime);
        }
    }

    private static class ActiveTime
    implements Comparable<ActiveTime> {
        public final UUID player;
        public long lastActiveTime;

        public ActiveTime(UUID player, long lastActiveTime) {
            this.player = player;
            this.lastActiveTime = lastActiveTime;
        }

        @Override
        public int compareTo(ActiveTime other) {
            return Long.compare(this.lastActiveTime, other.lastActiveTime);
        }
    }
}

