/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ClientChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkLoadingCapability {
    protected final World level;
    protected final Map<ChunkPos, Set<UUID>> activePlayersPerLoadedChunk = new HashMap<ChunkPos, Set<UUID>>();
    protected final Map<ChunkPos, Set<UUID>> inactivePlayersPerLoadedChunk = new HashMap<ChunkPos, Set<UUID>>();
    protected final Map<ChunkPos, Set<BlockPos>> chunkLoadersPerChunk = new HashMap<ChunkPos, Set<BlockPos>>();
    protected final Map<UUID, Set<ChunkPos>> loadedChunksPerPlayer = new HashMap<UUID, Set<ChunkPos>>();
    protected final Map<UUID, Set<ChunkPos>> availableChunksPerPlayer = new HashMap<UUID, Set<ChunkPos>>();
    protected final Map<UUID, Set<BlockPos>> chunkLoadersPerPlayer = new HashMap<UUID, Set<BlockPos>>();
    protected final Map<BlockPos, ChunkLoaderCache> chunkLoaderCacheMap = new HashMap<BlockPos, ChunkLoaderCache>();

    public static ChunkLoadingCapability get(World level) {
        return (ChunkLoadingCapability)level.getCapability(ChunkLoaders.CHUNK_LOADING_CAPABILITY).orElse(null);
    }

    public ChunkLoadingCapability(World level) {
        this.level = level;
    }

    public ServerChunkLoadingCapability castServer() {
        return (ServerChunkLoadingCapability)this;
    }

    public ClientChunkLoadingCapability castClient() {
        return (ClientChunkLoadingCapability)this;
    }

    public boolean isChunkLoadedByPlayer(UUID player, ChunkPos chunkPos) {
        return this.loadedChunksPerPlayer.containsKey(player) && this.loadedChunksPerPlayer.get(player).contains(chunkPos);
    }

    public boolean isChunkLoaded(ChunkPos chunkPos) {
        return this.activePlayersPerLoadedChunk.containsKey(chunkPos) || this.inactivePlayersPerLoadedChunk.containsKey(chunkPos);
    }

    public Set<ChunkPos> getChunksLoadedByPlayer(UUID player) {
        return Collections.unmodifiableSet(this.loadedChunksPerPlayer.getOrDefault(player, Collections.emptySet()));
    }

    public Set<UUID> getActivePlayersLoadingChunk(ChunkPos chunkPos) {
        return Collections.unmodifiableSet(this.activePlayersPerLoadedChunk.getOrDefault(chunkPos, Collections.emptySet()));
    }

    public Set<UUID> getInactivePlayersLoadingChunk(ChunkPos chunkPos) {
        return Collections.unmodifiableSet(this.inactivePlayersPerLoadedChunk.getOrDefault(chunkPos, Collections.emptySet()));
    }

    public boolean canPlayerLoadChunk(UUID player, ChunkPos chunkPos) {
        int maxLoadedChunks = ChunkLoadersConfig.maxLoadedChunksPerPlayer.get();
        return (maxLoadedChunks <= 0 || !this.loadedChunksPerPlayer.containsKey(player) || this.loadedChunksPerPlayer.get(player).size() < maxLoadedChunks) && this.availableChunksPerPlayer.containsKey(player) && this.availableChunksPerPlayer.get(player).contains(chunkPos);
    }

    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT chunkLoaderCachesTag = new ListNBT();
        for (ChunkLoaderCache cache : this.chunkLoaderCacheMap.values()) {
            chunkLoaderCachesTag.add((Object)cache.write());
        }
        compound.func_218657_a("chunkLoaderCaches", (INBT)chunkLoaderCachesTag);
        ListNBT loadedChunksPerPlayerTag = new ListNBT();
        for (Map.Entry<UUID, Set<ChunkPos>> entry : this.loadedChunksPerPlayer.entrySet()) {
            CompoundNBT playerTag = new CompoundNBT();
            playerTag.func_186854_a("player", entry.getKey());
            playerTag.func_197644_a("chunks", entry.getValue().stream().mapToLong(ChunkPos::func_201841_a).toArray());
            loadedChunksPerPlayerTag.add((Object)playerTag);
        }
        compound.func_218657_a("loadedChunksPerPlayer", (INBT)loadedChunksPerPlayerTag);
        return compound;
    }

    public void read(CompoundNBT compound) {
        ListNBT chunkLoaderCachesTag = compound.func_150295_c("chunkLoaderCaches", 10);
        chunkLoaderCachesTag.stream().map(CompoundNBT.class::cast).map(ChunkLoaderCache::read).forEach(cache -> {
            this.chunkLoaderCacheMap.put(cache.chunkLoaderPos, (ChunkLoaderCache)cache);
            this.chunkLoadersPerChunk.putIfAbsent(cache.chunkPos, new HashSet());
            this.chunkLoadersPerChunk.get(cache.chunkPos).add(cache.chunkLoaderPos);
            this.chunkLoadersPerPlayer.putIfAbsent(cache.owner, new HashSet());
            this.chunkLoadersPerPlayer.get(cache.owner).add(cache.chunkLoaderPos);
            int range = cache.chunkLoaderType.getRange();
            this.availableChunksPerPlayer.putIfAbsent(cache.owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    this.availableChunksPerPlayer.get(cache.owner).add(new ChunkPos(cache.chunkPos.field_77276_a + x, cache.chunkPos.field_77275_b + z));
                }
            }
        });
        ListNBT loadedChunksPerPlayerTag = compound.func_150295_c("loadedChunksPerPlayer", 10);
        loadedChunksPerPlayerTag.stream().map(CompoundNBT.class::cast).forEach(playerTag -> {
            UUID player = playerTag.func_186857_a("player");
            Collection chunks = Arrays.stream(playerTag.func_197645_o("chunks")).mapToObj(ChunkPos::new).collect(Collectors.toList());
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            this.loadedChunksPerPlayer.get(player).addAll(chunks);
            for (ChunkPos chunk : chunks) {
                if (PlayerActivityTracker.isPlayerActive(player)) {
                    this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    this.activePlayersPerLoadedChunk.get(chunk).add(player);
                    continue;
                }
                this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                this.inactivePlayersPerLoadedChunk.get(chunk).add(player);
            }
        });
    }
}

