/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Deprecated
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LegacyChunkLoadingCapability {
    private static final UUID LEGACY_GLOBAL_UUID = UUID.fromString("399cf0ed-1eb4-4e3d-92ca-856f579aac86");
    @CapabilityInject(value=ChunkTracker.class)
    public static Capability<ChunkTracker> TRACKER_CAPABILITY;

    public static void register() {
        CapabilityManager.INSTANCE.register(ChunkTracker.class, (Capability.IStorage)new Capability.IStorage<ChunkTracker>(){

            public CompoundNBT writeNBT(Capability<ChunkTracker> capability, ChunkTracker instance, Direction side) {
                return instance.write();
            }

            public void readNBT(Capability<ChunkTracker> capability, ChunkTracker instance, Direction side, INBT nbt) {
                instance.read((CompoundNBT)nbt);
            }
        }, ChunkTracker::new);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        final LazyOptional tracker = LazyOptional.of(() -> new ChunkTracker((ServerWorld)world));
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<INBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == TRACKER_CAPABILITY ? tracker.cast() : LazyOptional.empty();
            }

            public INBT serializeNBT() {
                return TRACKER_CAPABILITY.writeNBT(tracker.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                TRACKER_CAPABILITY.readNBT(tracker.orElse(null), null, nbt);
            }
        });
        e.addListener(() -> ((LazyOptional)tracker).invalidate());
    }

    public static class ChunkTracker {
        private final ServerWorld world;
        private final Map<ChunkPos, List<BlockPos>> chunks = new HashMap<ChunkPos, List<BlockPos>>();

        public ChunkTracker(ServerWorld world) {
            this.world = world;
        }

        public ChunkTracker() {
            this.world = null;
        }

        public void remove(BlockPos loader) {
            ArrayList<ChunkPos> toBeRemoved = new ArrayList<ChunkPos>();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                if (!entry.getValue().remove(loader) || !entry.getValue().isEmpty()) continue;
                toBeRemoved.add(entry.getKey());
            }
            for (ChunkPos chunkPos : toBeRemoved) {
                this.chunks.remove(chunkPos);
                this.world.func_217458_b(chunkPos.field_77276_a, chunkPos.field_77275_b, false);
            }
        }

        public CompoundNBT write() {
            CompoundNBT compound = new CompoundNBT();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                CompoundNBT chunkTag = new CompoundNBT();
                chunkTag.func_74772_a("chunk", entry.getKey().func_201841_a());
                LongArrayNBT blocks = new LongArrayNBT(entry.getValue().stream().map(BlockPos::func_218275_a).collect(Collectors.toList()));
                chunkTag.func_218657_a("blocks", (INBT)blocks);
                compound.func_218657_a(entry.getKey().field_77276_a + ";" + entry.getKey().field_77275_b + ";old", (INBT)chunkTag);
            }
            return compound;
        }

        public void read(CompoundNBT compound) {
            for (String key : compound.func_150296_c()) {
                CompoundNBT chunkTag = compound.func_74775_l(key);
                ChunkPos chunk = new ChunkPos(chunkTag.func_74763_f("chunk"));
                LongArrayNBT blocks = (LongArrayNBT)chunkTag.func_74781_a("blocks");
                ArrayList blockList = new ArrayList();
                Arrays.stream(blocks.func_197652_h()).mapToObj(BlockPos::func_218283_e).forEach(blockList::add);
                this.chunks.put(chunk, blockList);
                if (key.endsWith(";old")) continue;
                this.world.func_73046_m().func_82010_a(() -> this.world.func_217458_b(chunk.field_77276_a, chunk.field_77275_b, false));
            }
        }

        public void onLoadLevel(ForgeChunkManager.TicketHelper ticketHelper) {
            ticketHelper.removeAllTickets(LEGACY_GLOBAL_UUID);
            if (ChunkLoadersConfig.allowLegacyLoadedChunks.get().booleanValue()) {
                for (ChunkPos pos : this.chunks.keySet()) {
                    ForgeChunkManager.forceChunk((ServerWorld)this.world, (String)"chunkloaders", (UUID)LEGACY_GLOBAL_UUID, (int)pos.field_77276_a, (int)pos.field_77275_b, (boolean)true, (boolean)true);
                }
            }
        }
    }
}

