/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntityRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChunkLoadersClient {
    private static KeyBinding CHUNK_LOADING_SCREEN_KEY;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, () -> new ChunkLoaderBlockEntityRenderer((Block)type.getBlock(), type.getFullRotation()));
        }
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        CHUNK_LOADING_SCREEN_KEY = new KeyBinding("chunkloaders.keys.open_screen", 67, "chunkloaders.keys.category");
        ClientRegistry.registerKeyBinding((KeyBinding)CHUNK_LOADING_SCREEN_KEY);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoadersClient::onKey);
    }

    public static void onKey(InputEvent.KeyInputEvent e) {
        if (CHUNK_LOADING_SCREEN_KEY != null && CHUNK_LOADING_SCREEN_KEY.func_197976_a(e.getKey(), e.getScanCode()) && ClientUtils.getWorld() != null && ClientUtils.getMinecraft().field_71462_r == null) {
            PlayerEntity player = ClientUtils.getPlayer();
            if (ChunkLoadersConfig.canPlayersUseMap.get().booleanValue()) {
                ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(player.func_233580_cy_()), player.func_110124_au(), player.func_233580_cy_().func_177956_o(), 15, 11)));
            } else {
                player.func_146105_b((ITextComponent)TextComponents.translation((String)"chunkloaders.gui.disabled").color(TextFormatting.RED).get(), true);
            }
        }
    }

    public static void openChunkLoaderScreen(ChunkLoaderBlockEntity entity) {
        int size = entity.getChunkLoaderType().getGridSize() + 2;
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(entity.func_174877_v()), entity.getOwner(), entity.func_174877_v().func_177956_o(), size, size)));
    }
}

