/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.chunkloaders.LegacyChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ChunkLoaderBlock
extends BaseBlock
implements EntityHoldingBlock,
IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BlockShape SINGLE_SHAPE = BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final BlockShape BASIC_SHAPE = BlockShape.createBlockShape((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BlockShape ADVANCED_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final BlockShape ULTIMATE_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private final ChunkLoaderType type;

    public ChunkLoaderBlock(ChunkLoaderType type) {
        super(false, BlockProperties.create((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).requiresCorrectTool().destroyTime(1.5f).explosionResistance(6.0f));
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, Direction hitSide, Vector3d hitLocation) {
        TileEntity entity = level.func_175625_s(pos);
        if (entity instanceof ChunkLoaderBlockEntity) {
            if (((ChunkLoaderBlockEntity)entity).hasOwner()) {
                if (level.field_72995_K) {
                    ChunkLoadersClient.openChunkLoaderScreen((ChunkLoaderBlockEntity)entity);
                }
            } else if (player.func_225608_bj_()) {
                if (level.field_72995_K) {
                    player.func_146105_b((ITextComponent)TextComponents.translation((String)"chunkloaders.legacy_success").color(TextFormatting.WHITE).get(), true);
                } else {
                    ((ChunkLoaderBlockEntity)entity).setOwner(player.func_110124_au());
                    level.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY).ifPresent(cap -> cap.remove(pos));
                }
            } else if (level.field_72995_K) {
                player.func_146105_b((ITextComponent)TextComponents.translation((String)"chunkloaders.legacy_message").color(TextFormatting.RED).get(), true);
            }
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.type.getShape().getUnderlying();
    }

    public TileEntity createNewBlockEntity() {
        return this.type.createBlockEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof ChunkLoaderBlockEntity && placer instanceof PlayerEntity) {
            ((ChunkLoaderBlockEntity)entity).setOwner(placer.func_110124_au());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && entity instanceof ChunkLoaderBlockEntity) {
            if (((ChunkLoaderBlockEntity)entity).hasOwner()) {
                ChunkLoadingCapability.get(worldIn).castServer().removeChunkLoader((ChunkLoaderBlockEntity)entity);
            } else {
                worldIn.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY).ifPresent(cap -> cap.remove(pos));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void func_220082_b(BlockState newState, World level, BlockPos pos, BlockState oldState, boolean unknown) {
        TileEntity entity;
        if (!level.field_72995_K && level.func_73046_m() != null && newState.func_177230_c() == this && (entity = level.func_175625_s(pos)) instanceof ChunkLoaderBlockEntity) {
            level.func_73046_m().func_222817_e(() -> {
                if (!entity.func_145837_r()) {
                    entity.onLoad();
                }
            });
        }
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockReader level, Consumer<ITextComponent> info, boolean advanced) {
        if (this.type.getGridSize() == 1) {
            info.accept((ITextComponent)TextComponents.translation((String)"chunkloaders.chunk_loader.info.single").color(TextFormatting.AQUA).get());
        } else {
            info.accept((ITextComponent)TextComponents.translation((String)"chunkloaders.chunk_loader.info.multiple", (Object[])new Object[]{this.type.getGridSize()}).color(TextFormatting.AQUA).get());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }
}

