/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.book.Book;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientAdvancements {
    private static boolean gotFirstAdvPacket = false;

    public static void onClientPacket() {
        if (!gotFirstAdvPacket) {
            ClientBookRegistry.INSTANCE.reload();
            gotFirstAdvPacket = true;
        } else {
            ClientBookRegistry.INSTANCE.reloadLocks(false);
        }
    }

    public static boolean hasDone(String advancement) {
        ClientAdvancementManager cm;
        Advancement adv;
        ClientPlayNetHandler conn;
        ResourceLocation id = ResourceLocation.func_208304_a((String)advancement);
        if (id != null && (conn = Minecraft.func_71410_x().func_147114_u()) != null && (adv = (cm = conn.func_191982_f()).func_194229_a().func_192084_a(id)) != null) {
            Map progressMap = (Map)ObfuscationReflectionHelper.getPrivateValue(ClientAdvancementManager.class, (Object)cm, (String)"field_192803_d");
            AdvancementProgress progress = (AdvancementProgress)progressMap.get(adv);
            return progress != null && progress.func_192105_a();
        }
        return false;
    }

    @SubscribeEvent
    public static void playerLogout(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
        gotFirstAdvPacket = false;
    }

    public static void sendBookToast(Book book) {
        ToastGui gui = Minecraft.func_71410_x().func_193033_an();
        if (gui.func_192990_a(LexiconToast.class, (Object)book) == null) {
            gui.func_192988_a((IToast)new LexiconToast(book));
        }
    }

    public static class LexiconToast
    implements IToast {
        private final Book book;

        public LexiconToast(Book book) {
            this.book = book;
        }

        @Nonnull
        public Book getType() {
            return this.book;
        }

        @Nonnull
        public IToast.Visibility func_230444_a_(MatrixStack ms, ToastGui toastGui, long delta) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(field_193654_a);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.func_238474_b_(ms, 0, 0, 0, 32, 160, 32);
            toastGui.func_192989_b().field_71466_p.func_238421_b_(ms, I18n.func_135052_a((String)this.book.name, (Object[])new Object[0]), 30.0f, 7.0f, -11534256);
            toastGui.func_192989_b().field_71466_p.func_238421_b_(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.toast.info", (Object[])new Object[0]), 30.0f, 17.0f, -16777216);
            RenderHelper.renderItemStackInGui(ms, this.book.getBookItem(), 8, 8);
            return delta >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
    }
}

