/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaanpets.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class KehaanPetsWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "kehaanpets_SAFE";
    private final Map<UUID, Long> kehaanPetMap = new HashMap<UUID, Long>();

    public KehaanPetsWorldSavedData() {
        super(DATA_NAME);
    }

    public KehaanPetsWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT pokehaancraftaddTag = nbt.func_74775_l("kehaanpets");
        if (pokehaancraftaddTag.func_74764_b("pets")) {
            for (INBT nbtBase : pokehaancraftaddTag.func_150295_c("pets", 10)) {
                CompoundNBT tag = (CompoundNBT)nbtBase;
                UUID uuid = UUID.fromString(tag.func_74779_i("uuid"));
                if (!tag.func_74764_b("kehaanPet")) continue;
                this.kehaanPetMap.put(uuid, tag.func_74763_f("kehaanPet"));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT pokehaancraftaddTag = new CompoundNBT();
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        uuidSet.addAll(this.kehaanPetMap.keySet());
        ListNBT clickTagList = new ListNBT();
        for (UUID key : uuidSet) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("uuid", key.toString());
            tag.func_74772_a("kehaanPet", this.kehaanPetMap.getOrDefault(key, 0L).longValue());
            clickTagList.add((Object)tag);
        }
        pokehaancraftaddTag.func_218657_a("pets", (INBT)clickTagList);
        compound.func_218657_a("kehaanpets", (INBT)pokehaancraftaddTag);
        return compound;
    }

    public static KehaanPetsWorldSavedData get(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        DimensionSavedDataManager storage = ((ServerWorld)worldIn).func_73046_m().func_241755_D_().func_217481_x();
        return (KehaanPetsWorldSavedData)storage.func_215752_a(KehaanPetsWorldSavedData::new, DATA_NAME);
    }

    public long getKehaanPetLastUsed(UUID uuid) {
        return this.kehaanPetMap.getOrDefault(uuid, 0L);
    }

    public void saveKehaanPetLastUsed(UUID uuid, long currentTime) {
        this.kehaanPetMap.put(uuid, currentTime);
        this.func_76185_a();
    }
}

