/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaanpets.item;

import com.lclc98.kehaanpets.loader.KehaanPetsLoader;
import com.lclc98.kehaanpets.world.KehaanPetsWorldSavedData;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemKehaanPet
extends Item {
    public ItemKehaanPet() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName("kehaanpets", "kehaan_pet");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        KehaanPetsWorldSavedData savedData;
        long lastFed;
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        long currentTime = worldIn.func_82737_E();
        if (this.canUse(currentTime, lastFed = (savedData = KehaanPetsWorldSavedData.get(worldIn)).getKehaanPetLastUsed(playerIn.func_110124_au()))) {
            Ingredient consumableIngredient = KehaanPetsLoader.CONFIG.getConsumable();
            if (this.consumeIngredient(playerIn, consumableIngredient)) {
                savedData.saveKehaanPetLastUsed(playerIn.func_110124_au(), currentTime);
                playerIn.func_191521_c(this.getRandomCraftableItem(worldIn));
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
            }
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("kehaan_pet.kehaan_pet.no_food", new Object[]{new TranslationTextComponent(consumableIngredient.func_193365_a()[0].func_77977_a())}), true);
        } else {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("kehaan_pet.kehaan_pet.cooldown", new Object[]{this.getRemaining(currentTime, lastFed)}), true);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public boolean consumeIngredient(PlayerEntity player, Ingredient consumableIngredient) {
        NonNullList inv = player.field_71071_by.field_70462_a;
        for (ItemStack stack : inv) {
            if (!consumableIngredient.test(stack)) continue;
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public ItemStack getRandomCraftableItem(World world) {
        Collection optional = world.func_73046_m().func_199529_aN().func_199510_b();
        IRecipe recipe = optional.stream().skip(new Random().nextInt(optional.size())).findFirst().orElse(null);
        if (recipe == null) {
            return new ItemStack((IItemProvider)Blocks.field_150425_aM);
        }
        ItemStack itemStack = recipe.func_77571_b();
        if (KehaanPetsLoader.CONFIG.getBlacklistRecipe().test(itemStack)) {
            return this.getRandomCraftableItem(world);
        }
        return itemStack.func_77946_l();
    }

    public boolean canUse(long currentTime, long lastFed) {
        return lastFed == 0L || currentTime - lastFed >= (long)KehaanPetsLoader.CONFIG.cooldown;
    }

    public long getRemaining(long currentTime, long lastFed) {
        return ((long)KehaanPetsLoader.CONFIG.cooldown - (currentTime - lastFed)) / 20L;
    }
}

