/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;
import slimeknights.tconstruct.world.worldgen.islands.variants.IslandVariants;

public class SlimeIslandPiece
extends TemplateStructurePiece {
    private static final Random TREE_RANDOM = new Random();
    @Nullable
    private final ConfiguredFeature<?, ?> tree;
    private final String templateName;
    private final IIslandVariant variant;
    private final Rotation rotation;
    private final Mirror mirror;
    private int numberOfTreesPlaced;
    private ChunkGenerator chunkGenerator;

    public SlimeIslandPiece(TemplateManager templateManager, IIslandVariant variant, String templateName, BlockPos templatePosition, @Nullable ConfiguredFeature<?, ?> tree, Rotation rotation) {
        this(templateManager, variant, templateName, templatePosition, tree, rotation, Mirror.NONE);
    }

    public SlimeIslandPiece(TemplateManager templateManager, IIslandVariant variant, String templateName, BlockPos templatePosition, @Nullable ConfiguredFeature<?, ?> tree, Rotation rotation, Mirror mirror) {
        super(TinkerStructures.slimeIslandPiece, 0);
        this.templateName = templateName;
        this.variant = variant;
        this.field_186178_c = templatePosition;
        this.rotation = rotation;
        this.mirror = mirror;
        this.numberOfTreesPlaced = 0;
        this.tree = tree;
        this.loadTemplate(templateManager);
    }

    public SlimeIslandPiece(TemplateManager templateManager, CompoundNBT nbt) {
        super(TinkerStructures.slimeIslandPiece, nbt);
        this.templateName = nbt.func_74779_i("Template");
        this.variant = IslandVariants.getVariantFromIndex(nbt.func_74762_e("Variant"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.mirror = Mirror.valueOf((String)nbt.func_74779_i("Mi"));
        this.numberOfTreesPlaced = nbt.func_74762_e("NumberOfTreesPlaced");
        ResourceLocation tree = ResourceLocation.func_208304_a((String)nbt.func_74779_i("Tree"));
        this.tree = Optional.of(nbt.func_74779_i("Tree")).filter(s -> !s.isEmpty()).map(ResourceLocation::func_208304_a).flatMap(arg_0 -> ((Registry)WorldGenRegistries.field_243653_e).func_241873_b(arg_0)).orElse(null);
        this.loadTemplate(templateManager);
    }

    private void loadTemplate(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.variant.getStructureName(this.templateName));
        PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror).func_215222_a(this.variant.getStructureProcessor());
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        ResourceLocation key;
        super.func_143011_b(tagCompound);
        tagCompound.func_74778_a("Template", this.templateName);
        tagCompound.func_74768_a("Variant", this.variant.getIndex());
        tagCompound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
        tagCompound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        tagCompound.func_74768_a("NumberOfTreesPlaced", this.numberOfTreesPlaced);
        if (this.tree != null && (key = WorldGenRegistries.field_243653_e.func_177774_c(this.tree)) != null) {
            tagCompound.func_74778_a("Tree", key.toString());
        }
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        switch (function) {
            case "tconstruct:lake_bottom": {
                worldIn.func_180501_a(pos, this.variant.getLakeBottom(), 2);
                break;
            }
            case "tconstruct:slime_fluid": {
                worldIn.func_180501_a(pos, this.variant.getLakeFluid(), 2);
                break;
            }
            case "tconstruct:congealed_slime": {
                worldIn.func_180501_a(pos, this.variant.getCongealedSlime(rand), 2);
                break;
            }
            case "tconstruct:slime_vine": {
                BlockState vines = this.variant.getVines();
                if (vines == null || !rand.nextBoolean()) break;
                this.placeVine((IWorld)worldIn, pos, rand, vines);
                break;
            }
            case "tconstruct:slime_tree": {
                ISeedReader seedReader;
                if (this.tree == null || this.numberOfTreesPlaced >= 3 || !rand.nextBoolean() || !(worldIn instanceof ISeedReader) || !this.tree.func_242765_a(seedReader = (ISeedReader)worldIn, this.chunkGenerator, rand, pos)) break;
                ++this.numberOfTreesPlaced;
                break;
            }
            case "tconstruct:slime_tall_grass": {
                BlockState state;
                if (!rand.nextBoolean() || (state = this.variant.getPlant(rand)) == null || !(state.func_177230_c() instanceof BushBlock) || !((BushBlock)state.func_177230_c()).func_196260_a(state, (IWorldReader)worldIn, pos)) break;
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    private void placeVine(IWorld worldIn, BlockPos pos, Random random, BlockState vineToPlace) {
        BlockState state;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !SlimeVineBlock.func_196542_b((IBlockReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction)) continue;
            worldIn.func_180501_a(pos, (BlockState)vineToPlace.func_206870_a((Property)SlimeVineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.TRUE), 2);
        }
        BlockPos vinePos = pos;
        for (int size = random.nextInt(8); size >= 0 && (state = worldIn.func_180495_p(vinePos)).func_177230_c() instanceof SlimeVineBlock; --size) {
            ((SlimeVineBlock)state.func_177230_c()).grow(worldIn, random, vinePos, state);
            vinePos = vinePos.func_177977_b();
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox bounds, ChunkPos chunk, BlockPos pos) {
        this.chunkGenerator = generator;
        if (this.variant.isPositionValid(world, this.field_186178_c, generator)) {
            return super.func_230383_a_(world, manager, generator, rand, bounds, chunk, pos);
        }
        return false;
    }
}

