/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class BlastProtectionModifier
extends AbstractProtectionModifier<BlastData> {
    private static final TinkerDataCapability.TinkerDataKey<BlastData> BLAST_DATA = TConstruct.createKey("blast_protection");

    public BlastProtectionModifier() {
        super(1564002, BLAST_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ExplosionEvent.Detonate.class, BlastProtectionModifier::onExplosionDetonate);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, BlastProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float modifierValue) {
        if (!source.func_151517_h() && !source.func_76357_e() && source.func_94541_c()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    @Override
    protected BlastData createData() {
        return new BlastData();
    }

    @Override
    protected void reset(BlastData data) {
        data.wasKnockback = false;
    }

    private static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vector3d center = explosion.getPosition();
        float diameter = explosion.field_77280_f * 2.0f;
        for (Entity entity : event.getAffectedEntities()) {
            if (entity.func_180427_aV()) continue;
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.getMax() > 0.0f) {
                    double y;
                    double distance;
                    double x = entity.func_226277_ct_() - center.field_72450_a;
                    double z = entity.func_226281_cx_() - center.field_72449_c;
                    if ((x != 0.0 || z != 0.0 || entity.func_226280_cw_() - center.field_72448_b != 0.0) && (distance = (double)(MathHelper.func_76133_a((double)(x * x + (y = entity.func_226278_cu_() - center.field_72448_b) * y + z * z)) / diameter)) <= 1.0) {
                        blastData.wasKnockback = true;
                    }
                }
            });
        }
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.func_130014_f_().field_72995_K && !living.func_175149_v()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.wasKnockback) {
                    blastData.wasKnockback = false;
                    float max = blastData.getMax();
                    if (max > 0.0f) {
                        double scale = 1.0f - blastData.getMax() * 0.15f;
                        if (scale <= 0.0) {
                            living.func_213317_d(Vector3d.field_186680_a);
                        } else {
                            living.func_213317_d(living.func_213322_ci().func_216372_d(scale, scale, scale));
                        }
                        living.field_70133_I = true;
                    }
                }
            });
        }
    }

    protected static class BlastData
    extends ModifierMaxLevel {
        boolean wasKnockback = false;

        protected BlastData() {
        }
    }
}

