/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class EquipmentChangeWatcher
implements Capability.IStorage<PlayerLastEquipment> {
    private static final ResourceLocation ID = TConstruct.getResource("equipment_watcher");
    private static final EquipmentChangeWatcher INSTANCE = new EquipmentChangeWatcher();
    @CapabilityInject(value=PlayerLastEquipment.class)
    public static Capability<PlayerLastEquipment> CAPABILITY = null;

    private EquipmentChangeWatcher() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerLastEquipment.class, (Capability.IStorage)INSTANCE, () -> new PlayerLastEquipment(null));
        MinecraftForge.EVENT_BUS.addListener(EquipmentChangeWatcher::onEquipmentChange);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(EquipmentChangeWatcher::onPlayerTick);
            MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EquipmentChangeWatcher::attachCapability);
        }
    }

    private static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        EquipmentChangeWatcher.runModifierHooks(event.getEntityLiving(), event.getSlot(), event.getFrom(), event.getTo());
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity.func_130014_f_().field_72995_K && entity instanceof PlayerEntity) {
            PlayerLastEquipment provider = new PlayerLastEquipment((PlayerEntity)entity);
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT && event.player.field_70173_aa % 5 == 0) {
            event.player.getCapability(CAPABILITY).ifPresent(PlayerLastEquipment::update);
        }
    }

    private static void runModifierHooks(LivingEntity entity, EquipmentSlotType changedSlot, ItemStack original, ItemStack replacement) {
        EquipmentChangeContext context = new EquipmentChangeContext(entity, changedSlot, original, replacement);
        IModifierToolStack tool = context.getOriginalTool();
        if (tool != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onUnequip(tool, entry.getLevel(), context);
            }
        }
        if ((tool = context.getReplacementTool()) != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onEquip(tool, entry.getLevel(), context);
            }
        }
        for (EquipmentSlotType otherSlot : EquipmentSlotType.values()) {
            if (otherSlot == changedSlot || (tool = context.getToolInSlot(otherSlot)) == null) continue;
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onEquipmentChange(tool, entry.getLevel(), context, otherSlot);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ToolEquipmentChangeEvent(context));
    }

    @Nullable
    public INBT writeNBT(Capability<PlayerLastEquipment> capability, PlayerLastEquipment instance, Direction side) {
        return null;
    }

    public void readNBT(Capability<PlayerLastEquipment> capability, PlayerLastEquipment instance, Direction side, INBT nbt) {
    }

    protected static class PlayerLastEquipment
    implements ICapabilityProvider,
    Runnable {
        @Nullable
        private final PlayerEntity player;
        private final Map<EquipmentSlotType, ItemStack> lastItems = new EnumMap<EquipmentSlotType, ItemStack>(EquipmentSlotType.class);
        private LazyOptional<PlayerLastEquipment> capability;

        private PlayerLastEquipment(@Nullable PlayerEntity player) {
            this.player = player;
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                this.lastItems.put(slot, ItemStack.field_190927_a);
            }
            this.capability = LazyOptional.of(() -> this);
        }

        public void update() {
            if (this.player != null) {
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    ItemStack newStack = this.player.func_184582_a(slot);
                    ItemStack oldStack = this.lastItems.get(slot);
                    if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack)) continue;
                    this.lastItems.put(slot, newStack.func_77946_l());
                    EquipmentChangeWatcher.runModifierHooks((LivingEntity)this.player, slot, oldStack, newStack);
                }
            }
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> this);
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.capability);
        }
    }
}

