/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class SlimesuitItem
extends ModifiableArmorItem {
    private static final Map<String, String> ARMOR_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Map<String, String> LEG_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Function<String, String> ARMOR_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_1");
    private static final Function<String, String> LEG_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_2");

    public SlimesuitItem(ModifiableArmorMaterial material, ArmorSlotType slotType, Item.Properties properties) {
        super(material, slotType, properties);
    }

    public static String getMaterial(ItemStack stack) {
        if (ModifierUtil.getModifierLevel(stack, (Modifier)TinkerModifiers.golden.get()) > 0) {
            return MaterialIds.gold.toString();
        }
        String key = ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        if (key.isEmpty()) {
            return MaterialIds.enderslime.toString();
        }
        return key;
    }

    public static String makeArmorTexture(String material, String texture) {
        ResourceLocation location = ResourceLocation.func_208304_a((String)material);
        if (location == null) {
            location = MaterialIds.enderslime;
        }
        return String.format("%s:textures/models/armor/slime/%s_%s_%s.png", "tconstruct", texture, location.func_110624_b(), location.func_110623_a());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        String material = SlimesuitItem.getMaterial(stack);
        if (slot == EquipmentSlotType.LEGS) {
            return LEG_TEXTURE_CACHE.computeIfAbsent(material, LEG_GETTER);
        }
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(material, ARMOR_GETTER);
    }
}

