/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.utils.Util;

public class CreativeSlotItem
extends Item {
    private static final String NBT_KEY = "slot";
    private static final String TOOLTIP = TConstruct.makeTranslationKey("item", "creative_slot.tooltip");
    private static final ITextComponent TOOLTIP_MISSING = TConstruct.makeTranslation("item", "creative_slot.missing").func_240699_a_(TextFormatting.RED);

    public CreativeSlotItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static SlotType getSlot(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(NBT_KEY, 8)) {
            return SlotType.getIfPresent(nbt.func_74779_i(NBT_KEY));
        }
        return null;
    }

    public static ItemStack withSlot(ItemStack stack, SlotType type) {
        stack.func_196082_o().func_74778_a(NBT_KEY, type.getName());
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        String betterKey;
        SlotType slot = CreativeSlotItem.getSlot(stack);
        String originalKey = this.func_77658_a();
        if (slot != null && Util.canTranslate(betterKey = originalKey + "." + slot.getName())) {
            return betterKey;
        }
        return originalKey;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        SlotType slot = CreativeSlotItem.getSlot(stack);
        if (slot != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(TOOLTIP, new Object[]{slot.getDisplayName()}).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add(TOOLTIP_MISSING);
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            Collection<SlotType> allTypes = SlotType.getAllSlotTypes();
            if (allTypes.isEmpty()) {
                items.add((Object)new ItemStack((IItemProvider)this));
            } else {
                for (SlotType type : allTypes) {
                    items.add((Object)CreativeSlotItem.withSlot(new ItemStack((IItemProvider)this), type));
                }
            }
        }
    }
}

