/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final ValidatedResult TOO_MANY_PARTS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected final ResourceLocation id;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.func_190926_b() || !TinkerTags.Items.MULTIPART_TOOL.func_230235_a_((Object)tinkerable.func_77973_b()) || !(tinkerable.func_77973_b() instanceof IModifiable)) {
            return false;
        }
        List<PartRequirement> parts = ((IModifiable)tinkerable.func_77973_b()).getToolDefinition().getData().getParts();
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            if (foundItem) {
                return false;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof IToolPart) || parts.stream().noneMatch(p -> p.matches(item))) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        List<PartRequirement> parts = tool.getDefinition().getData().getParts();
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack itemStack;
            ValidatedResult toolValidation;
            int n;
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (!(item instanceof IToolPart)) {
                return ValidatedResult.PASS;
            }
            IToolPart part = (IToolPart)item;
            IMaterial partMaterial = ((IToolPart)item).getMaterial(stack);
            if (partMaterial == IMaterial.UNKNOWN) {
                return ValidatedResult.PASS;
            }
            int index = i;
            if (!(i < parts.size() && parts.get(i).matches(item) || (index = IntStream.range(0, parts.size()).filter(pi -> ((PartRequirement)parts.get(pi)).matches(item)).findFirst().orElse(-1)) != -1)) {
                return ValidatedResult.PASS;
            }
            IMaterial toolMaterial = tool.getMaterial(index);
            if (toolMaterial == partMaterial) {
                return ValidatedResult.PASS;
            }
            tool = tool.copy();
            HashMap<Modifier, Integer> removedTraits = new HashMap<Modifier, Integer>();
            for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(toolMaterial.getIdentifier(), part.getStatType())) {
                removedTraits.put(modifierEntry.getModifier(), modifierEntry.getLevel());
            }
            for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(partMaterial.getIdentifier(), part.getStatType())) {
                Modifier modifier = modifierEntry.getModifier();
                if (!removedTraits.containsKey(modifier)) continue;
                int value = (Integer)removedTraits.get(modifier) - modifierEntry.getLevel();
                if (value <= 0) {
                    removedTraits.remove(modifier);
                    continue;
                }
                removedTraits.put(modifier, value);
            }
            ArrayList<Modifier> actuallyRemoved = new ArrayList<Modifier>();
            for (Map.Entry entry : removedTraits.entrySet()) {
                Modifier modifier = (Modifier)entry.getKey();
                if (tool.getModifierLevel(modifier) > (Integer)entry.getValue()) continue;
                modifier.beforeRemoved(tool, tool.getRestrictedNBT());
                actuallyRemoved.add(modifier);
            }
            tool.replaceMaterial(index, partMaterial);
            for (Modifier modifier : actuallyRemoved) {
                modifier.onRemoved(tool);
            }
            IMaterialStats iMaterialStats = MaterialRegistry.getInstance().getMaterialStats(partMaterial.getIdentifier(), part.getStatType()).orElse(null);
            if (iMaterialStats instanceof IRepairableMaterialStats && (n = MaterialCastingLookup.getItemCost(part)) > 0) {
                ModifierEntry entry;
                float factor = (float)n / 3.0f;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((factor = (entry = iterator.next()).getModifier().getRepairFactor(tool, entry.getLevel(), factor)) <= 0.0f)) {
                }
                if (factor > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)((float)((IRepairableMaterialStats)iMaterialStats).getDurability() * factor));
                }
            }
            if ((toolValidation = ModifierRecipeLookup.checkRequirements(itemStack = tool.createStack(Math.min(tinkerable.func_190916_E(), this.shrinkToolSlotBy())), tool)).hasError()) {
                return toolValidation;
            }
            toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                return toolValidation;
            }
            for (Modifier modifier : actuallyRemoved) {
                toolValidation = modifier.validate(tool, 0);
                if (!toolValidation.hasError()) continue;
                return toolValidation;
            }
            return ValidatedResult.success(itemStack);
        }
        return ValidatedResult.PASS;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

