/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationDamagingRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult BROKEN = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "damaging.broken"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int damageAmount;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)inv.getTinkerableStack().func_77973_b())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        if (ToolDamageUtil.isBroken(inv.getTinkerableStack())) {
            return BROKEN;
        }
        ToolStack tool = ToolStack.copyFrom(inv.getTinkerableStack());
        int maxDamage = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.damageAmount);
        ToolDamageUtil.directDamage(tool, maxDamage, null, inv.getTinkerableStack());
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        int damageTaken = ToolStack.from(result).getDamage() - ToolStack.from(inv.getTinkerableStack()).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, damageTaken, this.damageAmount, ItemStack.field_190927_a);
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.tinkerStationDamagingSerializer.get();
    }

    public TinkerStationDamagingRecipe(ResourceLocation id, Ingredient ingredient, int damageAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.damageAmount = damageAmount;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final Ingredient ingredient;
        private final int damageAmount;

        public void build(Consumer<IFinishedRecipe> consumer) {
            ItemStack[] stacks = this.ingredient.func_193365_a();
            if (stacks.length == 0) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            this.build(consumer, Objects.requireNonNull(stacks[0].func_77973_b().getRegistryName()));
        }

        public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
            if (this.ingredient == Ingredient.field_193370_a) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
            consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
        }

        private Builder(Ingredient ingredient, int damageAmount) {
            this.ingredient = ingredient;
            this.damageAmount = damageAmount;
        }

        public static Builder damage(Ingredient ingredient, int damageAmount) {
            return new Builder(ingredient, damageAmount);
        }

        private class FinishedRecipe
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void func_218610_a(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.func_200304_c());
                json.addProperty("damage_amount", (Number)Builder.this.damageAmount);
            }

            public IRecipeSerializer<?> func_218609_c() {
                return (IRecipeSerializer)TinkerTables.tinkerStationDamagingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends RecipeSerializer<TinkerStationDamagingRecipe> {
        public TinkerStationDamagingRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"damage_amount");
            return new TinkerStationDamagingRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        public TinkerStationDamagingRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int damageAmount = buffer.func_150792_a();
            return new TinkerStationDamagingRecipe(id, ingredient, damageAmount);
        }

        public void write(PacketBuffer buffer, TinkerStationDamagingRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(recipe.damageAmount);
        }
    }
}

