/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.tank;

import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.CastingTileEntity;

public class CastingFluidHandler
implements IFluidHandler {
    private final CastingTileEntity tile;
    private FluidStack fluid = FluidStack.EMPTY;
    private int capacity = 0;
    private Fluid filter = Fluids.field_204541_a;
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_CAPACITY = "capacity";

    public boolean isFluidValid(FluidStack stack) {
        return !stack.isEmpty() && (this.filter == Fluids.field_204541_a || stack.getFluid() == this.filter);
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getCapacity() {
        if (this.capacity == 0) {
            return this.fluid.getAmount();
        }
        return this.capacity;
    }

    public void reset() {
        this.capacity = 0;
        this.fluid = FluidStack.EMPTY;
        this.filter = Fluids.field_204541_a;
        this.onContentsChanged();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int capacity = this.capacity;
        if (this.filter == null || this.capacity == 0) {
            Fluid fluid = resource.getFluid();
            capacity = this.tile.initNewCasting(resource, action);
            if (capacity <= 0) {
                return 0;
            }
            if (action.execute()) {
                this.capacity = capacity;
                this.filter = fluid;
            }
        }
        if (this.fluid.isEmpty()) {
            int amount = Math.min(capacity, resource.getAmount());
            if (action.execute()) {
                this.fluid = new FluidStack(resource, amount);
                this.onContentsChanged();
            }
            return amount;
        }
        if (!resource.isFluidEqual(this.fluid)) {
            return 0;
        }
        int space = capacity - this.fluid.getAmount();
        if (space <= 0) {
            return 0;
        }
        int amount = resource.getAmount();
        if (amount < space) {
            if (action.execute()) {
                this.fluid.grow(amount);
                this.onContentsChanged();
            }
            return amount;
        }
        if (action.execute()) {
            this.fluid.setAmount(capacity);
            this.onContentsChanged();
        }
        return space;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = Math.min(this.fluid.getAmount(), maxDrain);
        if (drained <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute()) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.tile.reset();
            } else {
                this.onContentsChanged();
            }
        }
        return stack;
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return this.fluid;
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isFluidValid(stack);
    }

    public void readFromNBT(CompoundNBT nbt) {
        Fluid fluid;
        this.capacity = nbt.func_74762_e(TAG_CAPACITY);
        if (nbt.func_150297_b(TAG_FLUID, 10)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l(TAG_FLUID)));
        }
        if (nbt.func_150297_b(TAG_FILTER, 8) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i(TAG_FILTER)))) != null) {
            this.filter = fluid;
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a(TAG_CAPACITY, this.capacity);
        if (!this.fluid.isEmpty()) {
            nbt.func_218657_a(TAG_FLUID, (INBT)this.fluid.writeToNBT(new CompoundNBT()));
        }
        if (this.filter != Fluids.field_204541_a) {
            nbt.func_74778_a(TAG_FILTER, Objects.requireNonNull(this.filter.getRegistryName()).toString());
        }
        return nbt;
    }

    protected void onContentsChanged() {
        this.tile.func_70296_d();
        World world = this.tile.func_145831_w();
        if (world != null && !world.field_72995_K) {
            TinkerNetwork.getInstance().sendToClientsAround(new FluidUpdatePacket(this.tile.func_174877_v(), this.getFluid()), (IWorld)world, this.tile.func_174877_v());
        }
    }

    public CastingFluidHandler(CastingTileEntity tile) {
        this.tile = tile;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

