/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.multiblock;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;

public class MultiblockStructureData {
    public static final String TAG_EXTRA_POS = "extra";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    private final BlockPos minPos;
    private final BlockPos maxPos;
    protected final Set<BlockPos> extra;
    private final boolean hasCeiling;
    private final boolean hasFrame;
    private final boolean hasFloor;
    private final BlockPos minInside;
    private final BlockPos maxInside;
    private final int innerX;
    private final int innerY;
    private final int innerZ;
    private final AxisAlignedBB bounds;

    public MultiblockStructureData(BlockPos minPos, BlockPos maxPos, Set<BlockPos> extraPositons, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.extra = extraPositons;
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.minInside = minPos.func_177982_a(1, hasFloor ? 1 : 0, 1);
        this.maxInside = maxPos.func_177982_a(-1, hasCeiling ? -1 : 0, -1);
        this.innerX = this.maxInside.func_177958_n() - this.minInside.func_177958_n() + 1;
        this.innerY = this.maxInside.func_177956_o() - this.minInside.func_177956_o() + 1;
        this.innerZ = this.maxInside.func_177952_p() - this.minInside.func_177952_p() + 1;
        this.bounds = new AxisAlignedBB(this.minInside, this.maxInside.func_177982_a(1, 1, 1));
    }

    public static boolean isWithin(BlockPos pos, BlockPos min, BlockPos max) {
        return pos.func_177958_n() >= min.func_177958_n() && pos.func_177956_o() >= min.func_177956_o() && pos.func_177952_p() >= min.func_177952_p() && pos.func_177958_n() <= max.func_177958_n() && pos.func_177956_o() <= max.func_177956_o() && pos.func_177952_p() <= max.func_177952_p();
    }

    public boolean withinBounds(BlockPos pos) {
        return MultiblockStructureData.isWithin(pos, this.minPos, this.maxPos);
    }

    public boolean isInside(BlockPos pos) {
        return MultiblockStructureData.isWithin(pos, this.minInside, this.maxInside);
    }

    public boolean contains(BlockPos pos) {
        return this.withinBounds(pos) && this.containsBase(pos);
    }

    private boolean containsBase(BlockPos pos) {
        if (!this.isInside(pos)) {
            if (this.hasFrame) {
                return true;
            }
            int edges = 0;
            if (pos.func_177958_n() == this.minPos.func_177958_n() || pos.func_177958_n() == this.maxPos.func_177958_n()) {
                ++edges;
            }
            if (pos.func_177952_p() == this.minPos.func_177952_p() || pos.func_177952_p() == this.maxPos.func_177952_p()) {
                ++edges;
            }
            if (this.hasFloor && pos.func_177956_o() == this.minPos.func_177956_o() || this.hasCeiling && pos.func_177958_n() == this.maxPos.func_177958_n()) {
                ++edges;
            }
            if (edges < 2) {
                return true;
            }
        }
        return this.extra.contains(pos);
    }

    public boolean isDirectlyAbove(BlockPos pos) {
        return pos.func_177958_n() >= this.minPos.func_177958_n() && pos.func_177952_p() >= this.minPos.func_177952_p() && pos.func_177958_n() <= this.maxPos.func_177958_n() && pos.func_177952_p() <= this.maxPos.func_177952_p() && pos.func_177956_o() == this.maxPos.func_177956_o() + 1;
    }

    protected void forEachContained(Consumer<BlockPos.Mutable> consumer) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = this.minPos.func_177958_n(); x <= this.maxPos.func_177958_n(); ++x) {
            for (int y = this.minPos.func_177956_o(); y <= this.maxPos.func_177956_o(); ++y) {
                for (int z = this.minPos.func_177952_p(); z <= this.maxPos.func_177952_p(); ++z) {
                    mutable.func_181079_c(x, y, z);
                    if (!this.containsBase((BlockPos)mutable)) continue;
                    consumer.accept(mutable);
                }
            }
        }
    }

    public void assignMaster(IMasterLogic master, @Nullable MultiblockStructureData oldStructure) {
        Predicate<BlockPos> shouldUpdate = oldStructure == null ? pos -> true : pos -> !oldStructure.contains((BlockPos)pos);
        World world = master.getTileEntity().func_145831_w();
        assert (world != null);
        this.forEachContained(pos -> {
            if (shouldUpdate.test((BlockPos)pos) && world.func_175667_e((BlockPos)pos)) {
                TileEntityHelper.getTile(IServantLogic.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.setPotentialMaster(master));
            }
        });
        if (oldStructure != null) {
            oldStructure.forEachContained(pos -> {
                if (!this.contains((BlockPos)pos) && world.func_175667_e((BlockPos)pos)) {
                    TileEntityHelper.getTile(IServantLogic.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.removeMaster(master));
                }
            });
        }
    }

    public void clearMaster(IMasterLogic master) {
        World world = master.getTileEntity().func_145831_w();
        assert (world != null);
        this.forEachContained(pos -> {
            if (world.func_175667_e((BlockPos)pos)) {
                TileEntityHelper.getTile(IServantLogic.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.removeMaster(master));
            }
        });
    }

    public CompoundNBT writeClientNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(TAG_MIN, (INBT)TagUtil.writePos(this.minPos));
        nbt.func_218657_a(TAG_MAX, (INBT)TagUtil.writePos(this.maxPos));
        return nbt;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = this.writeClientNBT();
        if (!this.extra.isEmpty()) {
            nbt.func_218657_a(TAG_EXTRA_POS, (INBT)MultiblockStructureData.writePosList(this.extra));
        }
        return nbt;
    }

    protected static ListNBT writePosList(Collection<BlockPos> collection) {
        ListNBT list = new ListNBT();
        for (BlockPos pos : collection) {
            list.add((Object)TagUtil.writePos(pos));
        }
        return list;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public BlockPos getMinInside() {
        return this.minInside;
    }

    public BlockPos getMaxInside() {
        return this.maxInside;
    }

    public int getInnerX() {
        return this.innerX;
    }

    public int getInnerY() {
        return this.innerY;
    }

    public int getInnerZ() {
        return this.innerZ;
    }

    public AxisAlignedBB getBounds() {
        return this.bounds;
    }
}

