/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module.alloying;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.IAlloyingModule;

public class SingleAlloyingModule
implements IAlloyingModule {
    private final MantleTileEntity parent;
    private final IMutableAlloyTank alloyTank;
    private AlloyRecipe lastRecipe;

    private World getWorld() {
        return Objects.requireNonNull(this.parent.func_145831_w(), "Parent tile entity has null world");
    }

    @Nullable
    private AlloyRecipe findRecipe() {
        World world = this.getWorld();
        if (this.lastRecipe != null && this.lastRecipe.canPerform(this.alloyTank)) {
            return this.lastRecipe;
        }
        Optional<AlloyRecipe> recipe = world.func_199532_z().func_215366_a(RecipeTypes.ALLOYING).values().stream().filter(r -> r instanceof AlloyRecipe).map(r -> (AlloyRecipe)r).filter(r -> this.alloyTank.canFit(r.getOutput(), 0) && r.canPerform(this.alloyTank)).findAny();
        if (recipe.isPresent()) {
            this.lastRecipe = recipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    @Override
    public boolean canAlloy() {
        return this.findRecipe() != null;
    }

    @Override
    public void doAlloy() {
        AlloyRecipe recipe = this.findRecipe();
        if (recipe != null) {
            recipe.performRecipe(this.alloyTank);
        }
    }

    public SingleAlloyingModule(MantleTileEntity parent, IMutableAlloyTank alloyTank) {
        this.parent = parent;
        this.alloyTank = alloyTank;
    }
}

