/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.inventory;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import slimeknights.mantle.inventory.ItemHandlerSlot;
import slimeknights.mantle.util.sync.ValidZeroIntReference;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.inventory.TriggeringBaseContainer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.controller.AlloyerTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.MixerAlloyTank;

public class AlloyerContainer
extends TriggeringBaseContainer<AlloyerTileEntity> {
    private boolean hasFuelSlot = false;

    public AlloyerContainer(int id, @Nullable PlayerInventory inv, @Nullable AlloyerTileEntity alloyer) {
        super((ContainerType)TinkerSmeltery.alloyerContainer.get(), id, inv, alloyer);
        if (alloyer != null) {
            TileEntity te;
            World world = alloyer.func_145831_w();
            if (world != null && world.field_72995_K) {
                MixerAlloyTank alloyTank = alloyer.getAlloyTank();
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.DOWN) continue;
                    alloyTank.refresh(direction, true);
                }
            }
            BlockPos down = alloyer.func_174877_v().func_177977_b();
            if (world != null && world.func_180495_p(down).func_235714_a_(TinkerTags.Blocks.FUEL_TANKS) && (te = world.func_175625_s(down)) != null) {
                this.hasFuelSlot = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(handler -> {
                    this.func_75146_a((Slot)new ItemHandlerSlot(handler, 0, 151, 32));
                    return true;
                }).isPresent();
            }
            this.addInventorySlots();
            Consumer<IntReferenceHolder> referenceConsumer = arg_0 -> ((AlloyerContainer)this).func_216958_a(arg_0);
            ValidZeroIntReference.trackIntArray(referenceConsumer, (IIntArray)alloyer.getFuelModule());
        }
    }

    public AlloyerContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (AlloyerTileEntity)AlloyerContainer.getTileEntityFromBuf((PacketBuffer)buf, AlloyerTileEntity.class));
    }

    public boolean isHasFuelSlot() {
        return this.hasFuelSlot;
    }
}

