/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;

public enum Byproduct implements IByproduct
{
    COPPER(true, (Supplier<? extends Fluid>)TinkerFluids.moltenCopper),
    IRON(true, (Supplier<? extends Fluid>)TinkerFluids.moltenIron),
    GOLD(true, (Supplier<? extends Fluid>)TinkerFluids.moltenGold),
    SMALL_GOLD("gold", true, (Supplier<? extends Fluid>)TinkerFluids.moltenGold, 16),
    COBALT(true, (Supplier<? extends Fluid>)TinkerFluids.moltenCobalt),
    TIN(false, (Supplier<? extends Fluid>)TinkerFluids.moltenTin),
    SILVER(false, (Supplier<? extends Fluid>)TinkerFluids.moltenSilver),
    NICKEL(false, (Supplier<? extends Fluid>)TinkerFluids.moltenNickel),
    LEAD(false, (Supplier<? extends Fluid>)TinkerFluids.moltenLead),
    PLATINUM("platinum", false, (Supplier<? extends Fluid>)TinkerFluids.moltenPlatinum, 16);

    private final String name;
    private final boolean alwaysPresent;
    private final Supplier<? extends Fluid> fluidSupplier;
    private final int nuggets;

    private Byproduct(boolean alwaysPresent, Supplier<? extends Fluid> fluidSupplier) {
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.alwaysPresent = alwaysPresent;
        this.fluidSupplier = fluidSupplier;
        this.nuggets = 48;
    }

    @Override
    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    private Byproduct(String name, boolean alwaysPresent, Supplier<? extends Fluid> fluidSupplier, int nuggets) {
        this.name = name;
        this.alwaysPresent = alwaysPresent;
        this.fluidSupplier = fluidSupplier;
        this.nuggets = nuggets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAlwaysPresent() {
        return this.alwaysPresent;
    }

    @Override
    public int getNuggets() {
        return this.nuggets;
    }
}

