/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.Tags;
import slimeknights.tconstruct.common.TinkerTags;

public enum SlimeType implements IStringSerializable
{
    EARTH(118094, 9230210, MaterialColor.field_151661_c, false),
    SKY(117709, 62682, MaterialColor.field_151648_G, false),
    ICHOR(16750349, 13670400, MaterialColor.field_151676_q, true, 10),
    ENDER(11488502, 11087359, MaterialColor.field_151678_z, false),
    BLOOD(11862273, 0xB80000, MaterialColor.field_151645_D, true);

    public static final SlimeType[] TINKER;
    public static final SlimeType[] TRUE_SLIME;
    public static final SlimeType[] LIQUID;
    public static final SlimeType[] OVERWORLD;
    public static final SlimeType[] NETHER;
    private final int color;
    private final int defaultFoliageColor;
    private final MaterialColor mapColor;
    private final boolean nether;
    private final int lightLevel;
    private final Tags.IOptionalNamedTag<Block> dirtBlockTag;
    private final Tags.IOptionalNamedTag<Block> grassBlockTag;
    private final Tags.IOptionalNamedTag<Item> slimeballTag;

    private SlimeType(int color, int defaultFoliageColor, MaterialColor mapColor, boolean nether, int lightLevel) {
        this.color = color;
        this.defaultFoliageColor = defaultFoliageColor;
        this.mapColor = mapColor;
        this.nether = nether;
        this.lightLevel = lightLevel;
        String name = this.func_176610_l();
        this.grassBlockTag = TinkerTags.Blocks.tag((nether ? "slimy_nylium/" : "slimy_grass/") + name);
        this.dirtBlockTag = TinkerTags.Blocks.tag("slimy_soil/" + ("blood".equals(name) ? "vanilla" : name));
        this.slimeballTag = TinkerTags.Items.forgeTag("slimeball/" + name);
    }

    private SlimeType(int color, int defaultFoliageColor, MaterialColor mapColor, boolean nether) {
        this(color, defaultFoliageColor, mapColor, nether, 0);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.US);
    }

    public int getColor() {
        return this.color;
    }

    public int getDefaultFoliageColor() {
        return this.defaultFoliageColor;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    public boolean isNether() {
        return this.nether;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public Tags.IOptionalNamedTag<Block> getDirtBlockTag() {
        return this.dirtBlockTag;
    }

    public Tags.IOptionalNamedTag<Block> getGrassBlockTag() {
        return this.grassBlockTag;
    }

    public Tags.IOptionalNamedTag<Item> getSlimeballTag() {
        return this.slimeballTag;
    }

    static {
        TINKER = new SlimeType[]{SKY, ENDER, BLOOD, ICHOR};
        TRUE_SLIME = new SlimeType[]{EARTH, SKY, ENDER, ICHOR};
        LIQUID = new SlimeType[]{EARTH, SKY, BLOOD, ENDER};
        OVERWORLD = new SlimeType[]{EARTH, SKY, ENDER};
        NETHER = new SlimeType[]{ICHOR, BLOOD};
    }
}

