/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.crt.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.plugin.crt.CRTHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.tconstruct.Fuel")
public class FuelManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addFuel(String name, CTFluidIngredient input, int duration, int temperature) {
        name = this.fixRecipeName(name);
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        FluidIngredient fluidIngredient = CRTHelper.mapFluidIngredient(input);
        MeltingFuel recipe = new MeltingFuel(id, "", fluidIngredient, duration, temperature);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe));
    }

    public void removeRecipe(IItemStack output) {
        throw new IllegalArgumentException("Cannot remove Fuel Recipes by an IItemStack output as it doesn't output anything! Use `removeRecipe(Fluid input)` instead!");
    }

    @ZenCodeType.Method
    public void removeRecipe(Fluid input) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, iRecipe -> {
            if (iRecipe instanceof MeltingFuel) {
                MeltingFuel recipe = (MeltingFuel)iRecipe;
                return recipe.getInputs().stream().anyMatch(fluidStack -> fluidStack.getFluid() == input);
            }
            return false;
        }));
    }

    public IRecipeType<MeltingFuel> getRecipeType() {
        return RecipeTypes.FUEL;
    }
}

