/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.UpdateTinkerSlotLayoutsPacket;

public class StationSlotLayoutLoader
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(StationSlotLayoutLoader.class);
    public static final String FOLDER = "tinkering/station_layouts";
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Ingredient.class, (Object)new IngredientSerializer()).registerTypeHierarchyAdapter(LayoutIcon.class, (Object)LayoutIcon.SERIALIZER).registerTypeAdapter(Pattern.class, (Object)Pattern.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private static final StationSlotLayoutLoader INSTANCE = new StationSlotLayoutLoader();
    private Map<ResourceLocation, StationSlotLayout> layoutMap = Collections.emptyMap();
    private final List<ResourceLocation> requiredLayouts = new ArrayList<ResourceLocation>();
    private List<StationSlotLayout> sortedSlots = Collections.emptyList();

    private StationSlotLayoutLoader() {
        super(GSON, FOLDER);
    }

    public void setSlots(Collection<StationSlotLayout> slots) {
        this.setSlots(slots.stream().collect(Collectors.toMap(StationSlotLayout::getName, Function.identity())));
    }

    private void setSlots(Map<ResourceLocation, StationSlotLayout> map) {
        this.layoutMap = map;
        this.sortedSlots = map.values().stream().filter(layout -> !layout.isMain()).sorted(Comparator.comparingInt(StationSlotLayout::getSortIndex)).collect(Collectors.toList());
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManager, IProfiler profiler) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : splashList.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                JsonObject object = JSONUtils.func_151210_l((JsonElement)value, (String)"station_layout");
                if (object.entrySet().isEmpty()) continue;
                StationSlotLayout layout = (StationSlotLayout)GSON.fromJson((JsonElement)object, StationSlotLayout.class);
                int size = layout.getInputSlots().size() + (layout.getToolSlot().isHidden() ? 0 : 1);
                if (size < 2) {
                    throw new JsonParseException("Too few slots for layout " + key + ", must have at least 2");
                }
                layout.setName(key);
                builder.put((Object)key, (Object)layout);
            }
            catch (Exception e) {
                log.error("Failed to load station slot layout for name {}", (Object)key, (Object)e);
            }
        }
        this.setSlots((Map<ResourceLocation, StationSlotLayout>)builder.build());
        log.info("Loaded {} station slot layouts in {} ms", (Object)this.layoutMap.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
        List missing = this.requiredLayouts.stream().filter(name -> !this.layoutMap.containsKey(name)).map(ResourceLocation::toString).collect(Collectors.toList());
        if (!missing.isEmpty()) {
            log.error("Failed to load the following required layouts: {}", (Object)String.join((CharSequence)", ", missing));
        }
    }

    public StationSlotLayout get(ResourceLocation name) {
        return this.layoutMap.getOrDefault(name, StationSlotLayout.EMPTY);
    }

    public void registerRequiredLayout(ResourceLocation name) {
        this.requiredLayouts.add(name);
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        UpdateTinkerSlotLayoutsPacket packet = new UpdateTinkerSlotLayoutsPacket(this.layoutMap.values());
        TinkerNetwork.getInstance().sendToPlayerList(event.getPlayer(), event.getPlayerList(), packet);
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }

    public static StationSlotLayoutLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::onDatapackSync);
    }

    public List<StationSlotLayout> getSortedSlots() {
        return this.sortedSlots;
    }

    private static class IngredientSerializer
    implements JsonSerializer<Ingredient>,
    JsonDeserializer<Ingredient> {
        private IngredientSerializer() {
        }

        public Ingredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Ingredient.func_199802_a((JsonElement)json);
        }

        public JsonElement serialize(Ingredient ingredient, Type typeOfSrc, JsonSerializationContext context) {
            return ingredient.func_200304_c();
        }
    }
}

