/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import net.minecraft.util.CombatRules;
import net.minecraft.util.math.MathHelper;

public class ArmorUtil {
    private ArmorUtil() {
    }

    public static float getDamageBeforeArmorAbsorb(float damage, float armor, float toughness) {
        if (damage <= 0.0f) {
            return 0.0f;
        }
        float boostedToughness = toughness + 8.0f;
        float atProduct = armor * boostedToughness;
        return 5.0f * MathHelper.func_76131_a((float)(((float)Math.sqrt(boostedToughness * (0.04f * armor * atProduct - 2.0f * atProduct + 25.0f * boostedToughness + 16.0f * damage)) + 0.2f * atProduct - 5.0f * boostedToughness) / 8.0f), (float)(damage * 25.0f / (125.0f - armor)), (float)damage);
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers) {
        if (enchantModifiers == 0.0f || damage <= 0.0f) {
            return damage;
        }
        return damage * (1.0f - MathHelper.func_76131_a((float)enchantModifiers, (float)-20.0f, (float)20.0f) / 25.0f);
    }

    public static float getDamageBeforeMagicAbsorb(float damage, float enchantModifiers) {
        return damage / (1.0f - MathHelper.func_76131_a((float)enchantModifiers, (float)0.0f, (float)20.0f) / 25.0f);
    }

    public static float getDamageForEvent(float originalDamage, float armor, float toughness, float vanillaModifiers, float finalModifiers) {
        if (vanillaModifiers == finalModifiers) {
            return originalDamage;
        }
        float damage = originalDamage;
        if (armor > 0.0f) {
            damage = CombatRules.func_189427_a((float)damage, (float)armor, (float)toughness);
        }
        if (finalModifiers != 0.0f) {
            damage = ArmorUtil.getDamageAfterMagicAbsorb(damage, finalModifiers);
        }
        if (vanillaModifiers > 0.0f) {
            damage = ArmorUtil.getDamageBeforeMagicAbsorb(damage, vanillaModifiers);
        }
        if (armor > 0.0f) {
            damage = ArmorUtil.getDamageBeforeArmorAbsorb(damage, armor, toughness);
        }
        return damage;
    }
}

