/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class PotionFluidEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final float effectScale;
    private final TagPredicate predicate;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Potion potion;
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null && this.predicate.test(fluid.getTag()) && (potion = PotionUtils.func_185187_c((CompoundNBT)fluid.getTag())) != Potions.field_185229_a) {
            int oldHurtResistance = target.field_70172_ad;
            float totalScale = scale * this.effectScale;
            for (EffectInstance instance : potion.func_185170_a()) {
                Effect effect = instance.func_188419_a();
                if (effect.func_76403_b()) {
                    target.field_70172_ad = 0;
                    effect.func_180793_a((Entity)attacker, (Entity)attacker, target, instance.func_76458_c(), (double)totalScale);
                    continue;
                }
                int duration = (int)((float)instance.func_76459_b() * totalScale);
                if (duration <= 10) continue;
                target.func_195064_c(new EffectInstance(effect, duration, instance.func_76458_c(), instance.func_82720_e(), instance.func_188418_e(), instance.func_205348_f()));
            }
            target.field_70172_ad = oldHurtResistance;
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }

    public PotionFluidEffect(float effectScale, TagPredicate predicate) {
        this.effectScale = effectScale;
        this.predicate = predicate;
    }

    private static class Loader
    implements ISpillingEffectLoader<PotionFluidEffect> {
        private Loader() {
        }

        @Override
        public PotionFluidEffect deserialize(JsonObject json) {
            float scale = JSONUtils.func_151217_k((JsonObject)json, (String)"scale");
            TagPredicate predicate = TagPredicate.ANY;
            if (json.has("predicate")) {
                predicate = TagPredicate.deserialize(json.get("predicate"));
            }
            return new PotionFluidEffect(scale, predicate);
        }

        @Override
        public PotionFluidEffect read(PacketBuffer buffer) {
            float scale = buffer.readFloat();
            TagPredicate predicate = TagPredicate.read(buffer);
            return new PotionFluidEffect(scale, predicate);
        }

        @Override
        public void serialize(PotionFluidEffect effect, JsonObject json) {
            json.addProperty("scale", (Number)Float.valueOf(effect.effectScale));
            if (effect.predicate != TagPredicate.ANY) {
                json.add("predicate", effect.predicate.serialize());
            }
        }

        @Override
        public void write(PotionFluidEffect effect, PacketBuffer buffer) {
            buffer.writeFloat(effect.effectScale);
            effect.predicate.write(buffer);
        }
    }
}

