/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;

public class SpillingRecipeLookup {
    private static final Map<Fluid, SpillingRecipe> CACHE = new HashMap<Fluid, SpillingRecipe>();
    private static final BiMap<ResourceLocation, ISpillingEffectLoader<?>> EFFECT_LOADERS = HashBiMap.create();

    @Nullable
    public static SpillingRecipe findRecipe(RecipeManager manager, Fluid fluid) {
        if (CACHE.containsKey(fluid)) {
            return CACHE.get(fluid);
        }
        for (SpillingRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.SPILLING, SpillingRecipe.class)) {
            if (!recipe.matches(fluid)) continue;
            CACHE.put(fluid, recipe);
            return recipe;
        }
        CACHE.put(fluid, null);
        return null;
    }

    public static void registerEffect(ResourceLocation name, ISpillingEffectLoader<?> loader) {
        EFFECT_LOADERS.putIfAbsent((Object)name, loader);
    }

    public static ISpillingEffect deserializeEffect(JsonObject json) {
        ResourceLocation type = JsonHelper.getResourceLocation((JsonObject)json, (String)"type");
        ISpillingEffectLoader loader = (ISpillingEffectLoader)EFFECT_LOADERS.get((Object)type);
        if (loader == null) {
            throw new JsonSyntaxException("Unknown spilling effect type " + type);
        }
        return loader.deserialize(json);
    }

    public static ISpillingEffect readEffect(PacketBuffer buffer) {
        ResourceLocation type = buffer.func_192575_l();
        ISpillingEffectLoader loader = (ISpillingEffectLoader)EFFECT_LOADERS.get((Object)type);
        if (loader == null) {
            throw new DecoderException("Unknown spilling effect type" + type);
        }
        return loader.read(buffer);
    }

    public static JsonObject serializeEffect(ISpillingEffect effect) {
        ISpillingEffectLoader<?> loader = effect.getLoader();
        JsonObject json = new JsonObject();
        ResourceLocation id = (ResourceLocation)EFFECT_LOADERS.inverse().get(loader);
        if (id == null) {
            throw new IllegalStateException("Attempted to serialize an unregistered loader " + loader);
        }
        json.addProperty("type", id.toString());
        loader.serialize(effect, json);
        return json;
    }

    public static void writeEffect(ISpillingEffect effect, PacketBuffer buffer) {
        ISpillingEffectLoader<?> loader = effect.getLoader();
        ResourceLocation id = (ResourceLocation)EFFECT_LOADERS.inverse().get(loader);
        if (id == null) {
            throw new EncoderException("Attempted to serialize an unregistered loader " + loader);
        }
        buffer.func_192572_a(id);
        loader.write(effect, buffer);
    }

    private SpillingRecipeLookup() {
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> CACHE.clear());
    }
}

