/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRequirements;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class ModifierRecipeLookup {
    public static final String DEFAULT_ERROR_KEY = TConstruct.makeTranslationKey("recipe", "modifier.requirements_error");
    public static final ValidatedResult DEFAULT_ERROR = ValidatedResult.failure(DEFAULT_ERROR_KEY, new Object[0]);
    private static final Set<Item> MODIFIERS = new HashSet<Item>();
    private static final Multimap<Modifier, ModifierRequirements> REQUIREMENTS = HashMultimap.create();
    private static final Object2IntMap<Modifier> INCREMENTAL_PER_LEVEL = new Object2IntOpenHashMap();
    private static final Multimap<Modifier, AbstractModifierSalvage> SALVAGE = HashMultimap.create();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        MODIFIERS.clear();
        REQUIREMENTS.clear();
        INCREMENTAL_PER_LEVEL.clear();
        SALVAGE.clear();
    });

    public static void addItem(Item item) {
        LISTENER.checkClear();
        MODIFIERS.add(item);
    }

    public static void addIngredient(Ingredient ingredient) {
        LISTENER.checkClear();
        for (ItemStack stack : ingredient.func_193365_a()) {
            MODIFIERS.add(stack.func_77973_b());
        }
    }

    public static void addIngredient(SizedIngredient ingredient) {
        LISTENER.checkClear();
        for (ItemStack stack : ingredient.getMatchingStacks()) {
            MODIFIERS.add(stack.func_77973_b());
        }
    }

    @Deprecated
    public static boolean isModifier(Item item) {
        return MODIFIERS.contains(item);
    }

    public static void addRequirements(ModifierRequirements requirements) {
        LISTENER.checkClear();
        REQUIREMENTS.put((Object)requirements.getModifier(), (Object)requirements);
    }

    public static void addRequirements(Ingredient ingredient, ModifierEntry entry, ModifierMatch requirements, String errorMessage) {
        if (requirements != ModifierMatch.ALWAYS) {
            ValidatedResult error = errorMessage.isEmpty() ? DEFAULT_ERROR : ValidatedResult.failure(errorMessage, new Object[0]);
            Modifier modifier = entry.getModifier();
            ModifierRecipeLookup.addRequirements(new ModifierRequirements(ingredient, modifier, requirements.getMinLevel(modifier) + entry.getLevel(), requirements, error));
        }
    }

    public static Collection<ModifierRequirements> getRequirements(Modifier modifier) {
        return REQUIREMENTS.get((Object)modifier);
    }

    public static ValidatedResult checkRequirements(ItemStack stack, IModifierToolStack tool) {
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
            for (ModifierRequirements requirements : ModifierRecipeLookup.getRequirements(entry.getModifier())) {
                ValidatedResult result = requirements.check(stack, entry.getLevel(), modifiers);
                if (!result.hasError()) continue;
                return result;
            }
        }
        return ValidatedResult.PASS;
    }

    public static void setNeededPerLevel(Modifier modifier, int neededPerLevel) {
        if (INCREMENTAL_PER_LEVEL.containsKey((Object)modifier)) {
            int original = INCREMENTAL_PER_LEVEL.getInt((Object)modifier);
            if (original != neededPerLevel) {
                TConstruct.LOG.warn("Inconsistent amount needed per level for {}, originally {}, newest {}, keeping largest", (Object)modifier, (Object)original, (Object)neededPerLevel);
            }
            if (neededPerLevel > original) {
                INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
            }
        } else {
            INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
        }
    }

    public static int getNeededPerLevel(Modifier modifier) {
        return INCREMENTAL_PER_LEVEL.getOrDefault((Object)modifier, 0);
    }

    public static void addSalvage(AbstractModifierSalvage salvage) {
        LISTENER.checkClear();
        SALVAGE.put((Object)salvage.getModifier(), (Object)salvage);
    }

    @Nullable
    public static AbstractModifierSalvage getSalvage(ItemStack stack, IModifierToolStack tool, Modifier modifier, int modifierLevel) {
        for (AbstractModifierSalvage salvage : SALVAGE.get((Object)modifier)) {
            if (!salvage.matches(stack, tool, modifierLevel)) continue;
            return salvage;
        }
        return null;
    }
}

