/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipeBuilder
extends AbstractRecipeBuilder<MaterialFluidRecipeBuilder> {
    private final MaterialId outputId;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int temperature = -1;
    @Nullable
    private MaterialId inputId;

    public MaterialFluidRecipeBuilder setFluidAndTemp(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.temperature == -1) {
            this.temperature = fluidStack.getFluid().getAttributes().getTemperature(fluidStack) - 300;
        }
        return this;
    }

    public MaterialFluidRecipeBuilder setFluid(ITag<Fluid> tagIn, int amount) {
        this.setFluid(FluidIngredient.of(tagIn, (int)amount));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.outputId);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Material fluid recipes require a fluid input");
        }
        if (this.temperature < 0) {
            throw new IllegalStateException("Temperature is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "materials");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private MaterialFluidRecipeBuilder(MaterialId outputId) {
        this.outputId = outputId;
    }

    public static MaterialFluidRecipeBuilder material(MaterialId outputId) {
        return new MaterialFluidRecipeBuilder(outputId);
    }

    public MaterialFluidRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public MaterialFluidRecipeBuilder setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public MaterialFluidRecipeBuilder setInputId(@Nullable MaterialId inputId) {
        this.inputId = inputId;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialFluidRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (MaterialFluidRecipeBuilder.this.inputId != null) {
                json.addProperty("input", MaterialFluidRecipeBuilder.this.inputId.toString());
            }
            json.add("fluid", MaterialFluidRecipeBuilder.this.fluid.serialize());
            json.addProperty("temperature", (Number)MaterialFluidRecipeBuilder.this.temperature);
            json.addProperty("output", MaterialFluidRecipeBuilder.this.outputId.toString());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerSmeltery.materialFluidRecipe.get();
        }
    }
}

