/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public abstract class AbstractCastingRecipe
implements ICastingRecipe {
    @Nonnull
    protected final IRecipeType<?> type;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient cast;
    protected final boolean consumed;
    protected final boolean switchSlots;

    public abstract ItemStack func_77571_b();

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.cast});
    }

    public AbstractCastingRecipe(@Nonnull IRecipeType<?> type, ResourceLocation id, String group, Ingredient cast, boolean consumed, boolean switchSlots) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.id = id;
        this.group = group;
        this.cast = cast;
        this.consumed = consumed;
        this.switchSlots = switchSlots;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public Ingredient getCast() {
        return this.cast;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean switchSlots() {
        return this.switchSlots;
    }

    public static abstract class Serializer<T extends AbstractCastingRecipe>
    extends LoggingRecipeSerializer<T> {
        protected abstract T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, boolean var4, boolean var5, JsonObject var6);

        protected abstract T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, boolean var4, boolean var5, PacketBuffer var6);

        protected abstract void writeExtra(PacketBuffer var1, T var2);

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient cast = Ingredient.field_193370_a;
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            boolean consumed = false;
            boolean switchSlots = JSONUtils.func_151209_a((JsonObject)json, (String)"switch_slots", (boolean)false);
            if (json.has("cast")) {
                cast = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"cast"));
                consumed = JSONUtils.func_151209_a((JsonObject)json, (String)"cast_consumed", (boolean)false);
            }
            return this.create(recipeId, group, cast, consumed, switchSlots, json);
        }

        @Override
        @Nullable
        protected T readSafe(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient cast = Ingredient.func_199566_b((PacketBuffer)buffer);
            boolean consumed = buffer.readBoolean();
            boolean switchSlots = buffer.readBoolean();
            return this.create(recipeId, group, cast, consumed, switchSlots, buffer);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((AbstractCastingRecipe)recipe).group);
            ((AbstractCastingRecipe)recipe).cast.func_199564_a(buffer);
            buffer.writeBoolean(((AbstractCastingRecipe)recipe).consumed);
            buffer.writeBoolean(((AbstractCastingRecipe)recipe).switchSlots);
            this.writeExtra(buffer, recipe);
        }
    }
}

