/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.traits;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.data.MergingJsonDataLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialTraitsJson;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.traits.MaterialTraits;
import slimeknights.tconstruct.library.materials.traits.UpdateMaterialTraitsPacket;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialTraitsManager
extends MergingJsonDataLoader<MaterialTraits.Builder> {
    private static final Logger log = LogManager.getLogger(MaterialTraitsManager.class);
    public static final String FOLDER = "materials/traits";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    @VisibleForTesting
    protected Map<MaterialId, MaterialTraits> materialTraits = Collections.emptyMap();

    public MaterialTraitsManager(Runnable onLoaded) {
        super(GSON, FOLDER, id -> new MaterialTraits.Builder());
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialTraitsManager() {
        this(() -> {});
    }

    public List<ModifierEntry> getDefaultTraits(MaterialId materialId) {
        MaterialTraits traits = this.materialTraits.get((Object)materialId);
        return traits == null ? Collections.emptyList() : traits.getDefaultTraits();
    }

    public boolean hasUniqueTraits(MaterialId materialId, MaterialStatsId statId) {
        MaterialTraits traits = this.materialTraits.get((Object)materialId);
        return traits != null && traits.hasUniqueTraits(statId);
    }

    public List<ModifierEntry> getTraits(MaterialId materialId, MaterialStatsId statId) {
        MaterialTraits traits = this.materialTraits.get((Object)materialId);
        return traits == null ? Collections.emptyList() : traits.getTraits(statId);
    }

    public UpdateMaterialTraitsPacket getUpdatePacket() {
        return new UpdateMaterialTraitsPacket(this.materialTraits);
    }

    public void updateFromServer(Map<MaterialId, MaterialTraits> materialToTraits) {
        this.materialTraits = materialToTraits;
        this.onLoaded.run();
    }

    @Override
    protected void parse(MaterialTraits.Builder builder, ResourceLocation id, JsonElement element) throws JsonSyntaxException {
        MaterialTraitsJson json = (MaterialTraitsJson)GSON.fromJson(element, MaterialTraitsJson.class);
        builder.setDefaultTraits(json.getDefaultTraits());
        for (Map.Entry<MaterialStatsId, List<ModifierEntry>> entry : json.getPerStat().entrySet()) {
            builder.setTraits(entry.getKey(), entry.getValue());
        }
        builder.setDefaultTraits(json.getDefaultTraits());
    }

    @Override
    protected void finishLoad(Map<ResourceLocation, MaterialTraits.Builder> map, IResourceManager manager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, MaterialTraits.Builder> entry : map.entrySet()) {
            MaterialTraits traits = entry.getValue().build();
            builder.put((Object)new MaterialId(entry.getKey()), (Object)traits);
            log.debug("Loaded traits for material '{}': \n\tDefault - {}{}", (Object)entry.getKey(), (Object)Arrays.toString(traits.getDefaultTraits().toArray()), (Object)Util.toIndentedStringList(traits.getTraitsPerStats().entrySet().stream().map(entry2 -> String.format("%s - %s", entry2.getKey(), Arrays.toString(((List)entry2.getValue()).toArray()))).collect(Collectors.toList())));
        }
        this.materialTraits = builder.build();
        this.onLoaded.run();
    }

    @Override
    public void func_195410_a(IResourceManager manager) {
        long time = System.nanoTime();
        super.func_195410_a(manager);
        log.info("{} traits loaded for {} materials in {} ms", (Object)this.materialTraits.values().stream().mapToInt(traits -> traits.getTraitsPerStats().size() + (traits.getDefaultTraits().isEmpty() ? 0 : 1)).sum(), (Object)this.materialTraits.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }
}

