/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.loot.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;

public class AddToolDataFunction
extends LootFunction {
    public static final ResourceLocation ID = TConstruct.getResource("add_tool_data");
    public static final Serializer SERIALIZER = new Serializer();
    private final float damage;
    private final List<RandomMaterial> materials;

    protected AddToolDataFunction(ILootCondition[] conditionsIn, float damage, List<RandomMaterial> materials) {
        super(conditionsIn);
        this.damage = damage;
        this.materials = materials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LootFunctionType func_230425_b_() {
        return TinkerTools.lootAddToolData;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)stack.func_77973_b())) {
            ToolStack tool = ToolStack.from(stack);
            ToolDefinition definition = tool.getDefinition();
            if (definition.isMultipart() && !this.materials.isEmpty()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                Random random = context.func_216032_b();
                for (RandomMaterial material : this.materials) {
                    builder.add((Object)material.getMaterial(random));
                }
                tool.setMaterials((List<IMaterial>)builder.build());
            } else {
                tool.rebuildStats();
            }
            if (this.damage > 0.0f) {
                tool.setDamage((int)((float)tool.getStats().getInt(ToolStats.DURABILITY) * this.damage));
            }
        }
        return stack;
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final ImmutableList.Builder<RandomMaterial> materials = ImmutableList.builder();
        private float damage = 0.0f;

        protected Builder() {
        }

        protected Builder doCast() {
            return this;
        }

        public void setDamage(float damage) {
            if (damage < 0.0f || damage > 1.0f) {
                throw new IllegalArgumentException("Damage must be between 0 and 1, given " + damage);
            }
            this.damage = damage;
        }

        public Builder addMaterial(RandomMaterial mat) {
            this.materials.add((Object)mat);
            return this;
        }

        public Builder addMaterial(MaterialId mat) {
            return this.addMaterial(RandomMaterial.fixed(mat));
        }

        public ILootFunction func_216052_b() {
            return new AddToolDataFunction(this.func_216053_g(), this.damage, (List<RandomMaterial>)this.materials.build());
        }
    }

    private static class Serializer
    extends LootFunction.Serializer<AddToolDataFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, AddToolDataFunction loot, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)loot, context);
            if (loot.damage > 0.0f) {
                json.addProperty("damage_percent", (Number)Float.valueOf(loot.damage));
            }
            if (!loot.materials.isEmpty()) {
                JsonArray array = new JsonArray();
                for (RandomMaterial material : loot.materials) {
                    array.add((JsonElement)material.serialize());
                }
                json.add("materials", (JsonElement)array);
            }
        }

        public AddToolDataFunction deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] conditions) {
            float damage = JSONUtils.func_151221_a((JsonObject)object, (String)"damage_percent", (float)0.0f);
            if (damage < 0.0f || damage > 1.0f) {
                throw new JsonSyntaxException("damage_percent must be between 0 and 1, given " + damage);
            }
            List materials = Collections.emptyList();
            if (object.has("materials")) {
                materials = JsonHelper.parseList((JsonObject)object, (String)"materials", RandomMaterial::deserialize);
            }
            return new AddToolDataFunction(conditions, damage, materials);
        }
    }
}

