/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerUtils {
    public static ItemStack getFirstItem(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasItems(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFull(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static int getUsedSlots(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int usedSlots = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ++usedSlots;
        }
        return usedSlots;
    }

    public static boolean extractStackFromPlayer(PlayerInventory inventory, IItemHandler targetHandler, Predicate<ItemStack> stackPredicate) {
        if (targetHandler != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (!stackPredicate.test(stack)) continue;
                ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)stack, (boolean)false);
                inventory.func_70299_a(i, restStack);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getAndSplit(IItemHandler itemhandler, int index, int amount) {
        return index >= 0 && index < itemhandler.getSlots() && !itemhandler.getStackInSlot(index).func_190926_b() && amount > 0 ? itemhandler.getStackInSlot(index).func_77979_a(amount) : ItemStack.field_190927_a;
    }

    public static ItemStack getAndRemove(IItemHandler itemhandler, int index) {
        if (index >= 0 && index < itemhandler.getSlots() && itemhandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)itemhandler;
            modifiable.setStackInSlot(index, ItemStack.field_190927_a);
            return modifiable.getStackInSlot(index);
        }
        return ItemStack.field_190927_a;
    }
}

