/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import com.mrbysco.forcecraft.blocks.ForceLogBlock;
import com.mrbysco.forcecraft.networking.PacketHandler;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ForceUtils {
    public static void removeEnchant(Enchantment enchantment, ItemStack stack) {
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantMap.containsKey(enchantment)) {
            enchantMap.remove(enchantment);
        }
        EnchantmentHelper.func_82782_a((Map)enchantMap, (ItemStack)stack);
    }

    public static boolean isTree(World world, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.func_177956_o() <= pos.func_177956_o() || !ForceUtils.isLog(world, candidate)) continue;
            pos = candidate.func_177984_a();
            while (ForceUtils.isLog(world, pos)) {
                pos = pos.func_177984_a();
            }
            candidates.add(pos.func_177978_c());
            candidates.add(pos.func_177974_f());
            candidates.add(pos.func_177968_d());
            candidates.add(pos.func_177976_e());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.func_177982_a(o + x, o + y, o + z);
                    BlockState state = world.func_180495_p(leaf);
                    if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h) || world.func_180495_p(pos).func_177230_c() instanceof ForceLogBlock;
    }

    public static void breakExtraBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos, BlockPos refPos) {
        if (!ForceUtils.canBreakExtraBlock(stack, world, player, pos, refPos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        FluidState fluidState = world.func_204610_c(pos);
        Block block = state.func_177230_c();
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true, fluidState)) {
                block.func_176208_a(world, pos, state, player);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b((ServerWorld)world, pos, xp);
            }
            PacketHandler.sendPacket((Entity)player, new SChangeBlockPacket((IBlockReader)world, pos));
        } else {
            world.func_175669_a(2001, pos, Block.func_196246_j((BlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true, fluidState)) {
                block.func_176208_a(world, pos, state, player);
            }
            stack.func_179548_a(world, state, pos, player);
            if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)Hand.MAIN_HAND);
                player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            ClientPlayNetHandler netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, pos, Direction.DOWN));
        }
    }

    private static boolean canBreakExtraBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        FluidState fluidState = world.func_204610_c(pos);
        Block block = state.func_177230_c();
        BlockState refState = world.func_180495_p(refPos);
        float refStrength = refState.func_185903_a(player, (IBlockReader)world, refPos);
        float strength = state.func_185903_a(player, (IBlockReader)world, pos);
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false, fluidState)) {
                block.func_176208_a(world, pos, state, player);
            }
            if (!world.field_72995_K) {
                PacketHandler.sendPacket((Entity)player, new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return false;
        }
        return true;
    }

    public static boolean isFakePlayer(Entity player) {
        return player instanceof FakePlayer;
    }

    public static String resource(String res) {
        return String.format("%s:%s", "forcecraft", res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation("forcecraft", res);
    }

    public static void teleportRandomly(LivingEntity livingEntity) {
        if (!livingEntity.field_70170_p.func_201670_d() && livingEntity.func_70089_S() && !livingEntity.func_203005_aq()) {
            double d0 = livingEntity.func_226277_ct_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 32.0;
            double d1 = livingEntity.func_226278_cu_() + (double)(livingEntity.func_70681_au().nextInt(32) - 16);
            double d2 = livingEntity.func_226281_cx_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 32.0;
            ForceUtils.teleportTo(livingEntity, d0, d1, d2);
        }
    }

    public static void teleportTo(LivingEntity living, double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !living.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = living.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent(living, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            boolean flag2 = living.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !living.func_174814_R()) {
                living.field_70170_p.func_184148_a((PlayerEntity)null, living.field_70169_q, living.field_70167_r, living.field_70166_s, SoundEvents.field_187534_aX, living.func_184176_by(), 1.0f, 1.0f);
                living.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }
}

