/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.tiles;

import com.mrbysco.forcecraft.blocks.torch.TimeTorchBlock;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class TimeTorchTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final List<BlockPos> positionList = new ArrayList<BlockPos>();
    private int speed;

    public TimeTorchTileEntity(TileEntityType<?> tileTypeIn) {
        super(tileTypeIn);
        this.speed = (Integer)ConfigHandler.COMMON.timeTorchAmount.get();
    }

    public TimeTorchTileEntity() {
        this((TileEntityType)ForceRegistry.TIME_TORCH_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int rate = (Integer)ConfigHandler.COMMON.timeTorchRate.get();
        if (rate > 0 && this.field_145850_b.func_82737_E() % (long)rate == 0L) {
            this.tickNeighbor();
        }
    }

    protected int speed(int base) {
        return base;
    }

    private void tickNeighbor() {
        if (this.positionList.isEmpty()) {
            this.initializePositions();
        }
        this.positionList.forEach(this::tickBlock);
    }

    private void initializePositions() {
        this.positionList.clear();
        this.positionList.addAll(BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(-1, -1, -1), (BlockPos)this.func_174877_v().func_177982_a(1, 1, 1)).map(BlockPos::func_185334_h).collect(Collectors.toList()));
    }

    private void tickBlock(@Nonnull BlockPos pos) {
        if (pos.equals((Object)this.func_174877_v()) || !this.field_145850_b.isAreaLoaded(pos, 1)) {
            return;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(pos);
        if (blockState != null) {
            Block block = blockState.func_177230_c();
            if (block == null || block instanceof FlowingFluidBlock || block instanceof TimeTorchBlock || blockState.func_196958_f()) {
                return;
            }
            if (block.func_149653_t(blockState) && !this.field_145850_b.field_72995_K) {
                for (int i = 0; i < this.speed && this.func_145831_w().func_180495_p(pos) == blockState; ++i) {
                    if (!this.func_145831_w().field_73012_v.nextBoolean()) continue;
                    block.func_225542_b_(blockState, (ServerWorld)this.field_145850_b, pos, this.field_145850_b.field_73012_v);
                }
            }
            if (block.hasTileEntity(blockState)) {
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (tile == null || !tile.func_145830_o() || tile.func_145837_r()) {
                    return;
                }
                for (int i = 0; i < this.speed && !tile.func_145837_r(); ++i) {
                    if (!(tile instanceof ITickableTileEntity) || !this.func_145831_w().field_73012_v.nextBoolean()) continue;
                    ((ITickableTileEntity)tile).func_73660_a();
                }
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT tag = super.func_189515_b(compound);
        tag.func_74768_a("Speed", this.speed);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("Speed")) {
            this.speed = nbt.func_74762_e("Speed");
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

