/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.tiles;

import com.mrbysco.forcecraft.blocks.engine.ForceEngineBlock;
import com.mrbysco.forcecraft.capablilities.FluidHandlerWrapper;
import com.mrbysco.forcecraft.capablilities.ItemStackHandlerWrapper;
import com.mrbysco.forcecraft.container.engine.ForceEngineContainer;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ForceEngineTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int MAX_FLUID = 10000;
    protected FluidTank tankFuel = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineTile.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineTile.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.func_207185_a(ForceTags.FORCE) || fluid.func_207185_a((ITag)FluidTags.field_206960_b) || fluid.func_207185_a(ForceTags.FUEL) || fluid.func_207185_a(ForceTags.BIOFUEL);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.func_207185_a(ForceTags.FORCE) || fluid.func_207185_a((ITag)FluidTags.field_206960_b) || fluid.func_207185_a(ForceTags.FUEL) || fluid.func_207185_a(ForceTags.BIOFUEL);
        }
    };
    protected FluidTank tankThrottle = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineTile.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineTile.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.func_207187_a((Fluid)Fluids.field_204546_a) || fluid.func_207185_a(ForceTags.MILK);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.func_207187_a((Fluid)Fluids.field_204546_a) || fluid.func_207185_a(ForceTags.MILK);
        }
    };
    private FluidHandlerWrapper tankWrapper = new FluidHandlerWrapper(this.tankThrottle, this.tankFuel);
    private LazyOptional<IFluidHandler> tankWrapperCap = LazyOptional.of(() -> this.tankWrapper);
    public final ItemStackHandler inputHandler = new ItemStackHandler(2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && stack.func_77976_d() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            IFluidHandler fluidCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
            if (slot == 0) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.func_207185_a(ForceTags.FORCE) || fluid.func_207185_a((ITag)FluidTags.field_206960_b) || fluid.func_207185_a(ForceTags.FUEL) || fluid.func_207185_a(ForceTags.BIOFUEL);
                }
                return stack.func_77973_b().func_206844_a(ForceTags.FORGE_GEM) || stack.func_77973_b().func_206844_a((ITag)Tags.Items.NETHER_STARS) || fluidCap != null && fluidCap.getFluidInTank(0).getFluid().func_207185_a(ForceTags.FORCE);
            }
            if (slot == 1) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.func_207187_a((Fluid)Fluids.field_204546_a) || fluid.func_207185_a(ForceTags.MILK);
                }
                return false;
            }
            return false;
        }
    };
    public final ItemStackHandler outputHandler = new ItemStackHandler(2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && stack.func_77976_d() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };
    private ItemStackHandlerWrapper stackWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outputHandler);
    private LazyOptional<IItemHandler> stackWrapperCap = LazyOptional.of(() -> this.stackWrapper);
    private static final int FLUID_PER_GEM = 500;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public int throttleTime = 0;
    public int maxThrottleTime = 10;
    private Fluid cachedFuel;
    private Fluid cachedThrottle;
    public float generating = 0.0f;

    public ForceEngineTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ForceEngineTile() {
        this((TileEntityType)ForceRegistry.FORCE_ENGINE_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.processTime = nbt.func_74762_e("processTime");
        this.maxProcessTime = nbt.func_74762_e("maxProcessTime");
        this.throttleTime = nbt.func_74762_e("throttleTime");
        this.maxThrottleTime = nbt.func_74762_e("maxThrottleTime");
        this.generating = nbt.func_74760_g("generating");
        this.stackWrapper.deserializeNBT(nbt.func_74775_l("stackHandler"));
        this.tankWrapper.deserializeNBT(nbt.func_74775_l("fluid"));
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("processTime", this.processTime);
        compound.func_74768_a("maxProcessTime", this.maxProcessTime);
        compound.func_74768_a("throttleTime", this.throttleTime);
        compound.func_74768_a("maxThrottleTime", this.maxThrottleTime);
        compound.func_74776_a("generating", this.generating);
        compound.func_218657_a("stackHandler", (INBT)this.stackWrapper.serializeNBT());
        compound.func_218657_a("fluid", (INBT)this.tankWrapper.serializeNBT());
        return compound;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("forcecraft.container.force_engine");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new ForceEngineContainer(id, playerInv, this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.inputHandler.getStackInSlot(0).func_190926_b()) {
            this.processFuelSlot();
            this.refreshClient();
        }
        if (!this.inputHandler.getStackInSlot(1).func_190926_b()) {
            this.processThrottleSlot();
            this.refreshClient();
        }
        if (this.isActive() && this.canWork()) {
            this.checkFluids();
            if (this.getFuelAmount() > 0) {
                ++this.processTime;
                this.insertPower();
                if (this.processTime >= this.maxProcessTime) {
                    this.tankFuel.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    this.processTime = 0;
                }
            }
            if (this.getThrottleAmount() > 0) {
                ++this.throttleTime;
                if (this.throttleTime >= this.maxThrottleTime) {
                    this.tankThrottle.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    this.throttleTime = 0;
                }
            }
            this.refreshClient();
        } else if (this.processTime != 0) {
            this.processTime = 0;
        }
    }

    public void checkFluids() {
        if (this.cachedFuel == null || !this.getFuelFluid().func_207187_a(this.cachedFuel)) {
            this.cachedFuel = this.getFuelFluid();
            this.reevaluateValues();
        }
        if (this.cachedThrottle == null || !this.getThrottleFluid().func_207187_a(this.cachedThrottle)) {
            this.cachedThrottle = this.getThrottleFluid();
            this.reevaluateValues();
        }
    }

    public void reevaluateValues() {
        if (this.cachedFuel != null) {
            FluidStack fuelStack = this.getFuelFluidStack();
            this.processTime = 0;
            this.maxProcessTime = this.getTimePerFuelMB(fuelStack);
            this.generating = this.getPowerForFluid(fuelStack);
            this.throttleTime = 0;
            this.maxThrottleTime = this.getTimePerThrottleMB(this.getThrottleFluidStack());
        }
        this.refreshClient();
    }

    private float getThrottleValue() {
        FluidStack throttleStack = this.getThrottleFluidStack();
        if (!throttleStack.isEmpty()) {
            Fluid fluid = throttleStack.getFluid();
            if (fluid.func_207185_a(ForceTags.MILK)) {
                return 2.5f;
            }
            if (fluid.func_207187_a((Fluid)Fluids.field_204546_a)) {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    public int getPowerForFluid(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            float throttleValue = this.getThrottleValue();
            Fluid fluid = fluidStack.getFluid();
            if (fluid.func_207185_a(ForceTags.FORCE)) {
                return (int)(20.0f * throttleValue);
            }
            if (fluid.func_207185_a((ITag)FluidTags.field_206960_b)) {
                return (int)(5.0f * throttleValue);
            }
            if (fluid.func_207185_a(ForceTags.FUEL)) {
                return (int)(10.0f * throttleValue);
            }
            if (fluid.func_207185_a(ForceTags.BIOFUEL)) {
                return (int)(15.0f * throttleValue);
            }
        }
        return 0;
    }

    public int getTimePerFuelMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.func_207185_a(ForceTags.FORCE)) {
                return 20;
            }
            if (fluid.func_207185_a((ITag)FluidTags.field_206960_b)) {
                return 20;
            }
            if (fluid.func_207185_a(ForceTags.FUEL)) {
                return 20;
            }
            if (fluid.func_207185_a(ForceTags.BIOFUEL)) {
                return 20;
            }
        }
        return 0;
    }

    public int getTimePerThrottleMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.func_207185_a(ForceTags.MILK)) {
                return 5;
            }
            if (fluid.func_207187_a((Fluid)Fluids.field_204546_a)) {
                return 5;
            }
        }
        return 0;
    }

    public boolean isActive() {
        return this.func_195044_w().func_177230_c() instanceof ForceEngineBlock && (Boolean)this.func_195044_w().func_177229_b((Property)ForceEngineBlock.ACTIVE) != false;
    }

    public Direction getFacing() {
        if (this.func_195044_w().func_177230_c() instanceof ForceEngineBlock) {
            return (Direction)this.func_195044_w().func_177229_b((Property)ForceEngineBlock.field_176387_N);
        }
        return Direction.NORTH;
    }

    public boolean canWork() {
        IEnergyStorage cap;
        BlockPos offsetPos = this.field_174879_c.func_177972_a(this.getFacing());
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (tile != null && (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, this.getFacing().func_176734_d()).orElse(null)) != null) {
            return cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored() && !this.tankFuel.getFluid().isEmpty();
        }
        return false;
    }

    public void insertPower() {
        IEnergyStorage cap;
        BlockPos offsetPos = this.field_174879_c.func_177972_a(this.getFacing());
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (tile != null && (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, this.getFacing().func_176734_d()).orElse(null)) != null && cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
            cap.receiveEnergy((int)this.generating, false);
        }
    }

    private void processFuelSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.stackWrapper.getStackInSlot(0);
        if (slotStack.func_77973_b().func_206844_a(ForceTags.FORGE_GEM)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity()) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.func_190918_g(1);
            }
        } else if (slotStack.func_77973_b().func_206844_a((ITag)Tags.Items.NETHER_STARS)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 5000);
            ItemStack extraSlot = this.outputHandler.getStackInSlot(0);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity() && extraSlot.func_190916_E() < this.inputHandler.getSlotLimit(1)) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.func_190918_g(1);
                if (this.outputHandler.getStackInSlot(0).func_190926_b()) {
                    this.outputHandler.setStackInSlot(0, new ItemStack((IItemProvider)ForceRegistry.INERT_CORE.get()));
                } else {
                    extraSlot.func_190920_e(extraSlot.func_190916_E() + 1);
                }
            }
        } else if (this.outputHandler.getStackInSlot(0).func_190926_b() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankFuel, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.func_190918_g(1);
            this.outputHandler.setStackInSlot(0, result.getResult());
        }
    }

    public int fillFuel(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankFuel.getFluid().isEmpty() || this.tankFuel.getFluid().isFluidEqual(resource))) {
            this.tankFuel.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    private void processThrottleSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.inputHandler.getStackInSlot(1);
        if (this.outputHandler.getStackInSlot(1).func_190926_b() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankThrottle, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.func_190918_g(1);
            this.outputHandler.setStackInSlot(1, result.getResult());
        }
    }

    public int fillThrottle(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankThrottle.getFluid().isEmpty() || this.tankThrottle.getFluid().isFluidEqual(resource))) {
            this.tankThrottle.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFuelFluid() {
        return this.getFuelFluidStack().getFluid();
    }

    public FluidStack getFuelFluidStack() {
        return this.tankFuel.getFluid();
    }

    public int getFuelAmount() {
        return this.tankFuel.getFluidAmount();
    }

    public void setFuelAmount(int amount) {
        if (amount > 0) {
            if (!this.tankFuel.getFluid().isEmpty()) {
                this.tankFuel.getFluid().setAmount(amount);
            }
        } else {
            this.tankFuel.setFluid(FluidStack.EMPTY);
        }
    }

    public Fluid getThrottleFluid() {
        return this.getThrottleFluidStack().getFluid();
    }

    public FluidStack getThrottleFluidStack() {
        return this.tankThrottle.getFluid();
    }

    public int getThrottleAmount() {
        return this.tankThrottle.getFluidAmount();
    }

    public void setThrottleAmount(int amount) {
        if (amount > 0) {
            if (!this.tankThrottle.getFluid().isEmpty()) {
                this.tankThrottle.getFluid().setAmount(amount);
            }
        } else {
            this.tankThrottle.setFluid(FluidStack.EMPTY);
        }
    }

    protected boolean isFluidEqual(FluidTank fluidTank, FluidStack fluid) {
        return this.isFluidEqual(fluidTank, fluid.getFluid());
    }

    protected boolean isFluidEqual(FluidTank fluidTank, Fluid fluid) {
        return fluidTank.getFluid().getFluid().equals(fluid);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT getTileData() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    private void refreshClient() {
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.stackWrapperCap.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapperCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.stackWrapperCap.invalidate();
        this.tankWrapperCap.invalidate();
    }
}

