/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.tiles;

import com.google.common.collect.Lists;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractForceFurnaceTile
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    public static final int INPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int UPGRADE_SLOT = 0;
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    public final ItemStackHandler handler = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 1) {
                ItemStack itemstack = this.getStackInSlot(1);
                return AbstractForceFurnaceTile.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
            }
            return slot != 2;
        }
    };
    private LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    public final ItemStackHandler upgradeHandler = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.getStackInSlot(slot).func_190926_b() && stack.func_77973_b() instanceof UpgradeCoreItem && stack.func_190916_E() == 1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };
    private LazyOptional<IItemHandler> upgradeHandlerHolder = LazyOptional.of(() -> this.upgradeHandler);
    private static final List<ResourceLocation> hopperBlacklist = Arrays.asList(ResourceLocation.func_208304_a((String)"hopper"), new ResourceLocation("cyclic", "hopper"), new ResourceLocation("cyclic", "hopper_gold"), new ResourceLocation("cyclic", "hopper_fluid"), new ResourceLocation("uppers", "upper"), new ResourceLocation("goldenhopper", "golden_hopper"), new ResourceLocation("woodenhopper", "wooden_hopper"));
    private int burnTime;
    private int burnSpeed;
    private int burnTimeTotal;
    private int cookTime;
    private int cookTimeTotal;
    private int cookSpeed;
    protected final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractForceFurnaceTile.this.burnTime;
                }
                case 1: {
                    return AbstractForceFurnaceTile.this.burnTimeTotal;
                }
                case 2: {
                    return AbstractForceFurnaceTile.this.cookTime;
                }
                case 3: {
                    return AbstractForceFurnaceTile.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractForceFurnaceTile.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractForceFurnaceTile.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    AbstractForceFurnaceTile.this.cookTime = value;
                    break;
                }
                case 3: {
                    AbstractForceFurnaceTile.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    protected AbstractCookingRecipe currentRecipe;
    protected ItemStack failedMatch = ItemStack.field_190927_a;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractForceFurnaceTile(TileEntityType<?> tileTypeIn) {
        super(tileTypeIn);
    }

    protected IRecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        ItemStack upgrade = this.getUpgrade();
        if (!upgrade.func_190926_b()) {
            if (upgrade.func_77973_b() == ForceRegistry.FREEZING_CORE.get()) {
                return ForceRecipes.FREEZING;
            }
            if (upgrade.func_77973_b() == ForceRegistry.GRINDING_CORE.get()) {
                return ForceRecipes.GRINDING;
            }
        }
        return IRecipeType.field_222150_b;
    }

    public void setUpgrade(ItemStack upgrade) {
        this.upgradeHandler.setStackInSlot(0, upgrade);
    }

    public ItemStack getUpgrade() {
        return this.upgradeHandler.getStackInSlot(0);
    }

    public boolean isEfficient() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().func_190926_b() && upgrade.func_77973_b() == ForceRegistry.HEAT_CORE.get();
    }

    public boolean isFast() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().func_190926_b() && upgrade.func_77973_b() == ForceRegistry.SPEED_CORE.get();
    }

    public boolean hasXPMultiplied() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().func_190926_b() && upgrade.func_77973_b() == ForceRegistry.EXPERIENCE_CORE.get();
    }

    public int getSpeed() {
        return this.isFast() ? 10 : 2;
    }

    public int getXPMultiplier() {
        return this.hasXPMultiplied() ? 2 : 1;
    }

    protected AbstractCookingRecipe getRecipe() {
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b() || input == this.failedMatch) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.func_77569_a((IInventory)this, this.field_145850_b) && this.currentRecipe.func_222127_g() == this.getRecipeType()) {
            return this.currentRecipe;
        }
        AbstractCookingRecipe rec = this.field_145850_b.func_199532_z().func_215371_a(this.getRecipeType(), (IInventory)this, this.field_145850_b).orElse(null);
        this.failedMatch = rec == null ? input : ItemStack.field_190927_a;
        this.currentRecipe = rec;
        return this.currentRecipe;
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("UpgradeHandler") && nbt.func_74764_b("ItemStackHandler")) {
            this.upgradeHandler.deserializeNBT(nbt.func_74775_l("UpgradeHandler"));
            this.handler.deserializeNBT(nbt.func_74775_l("ItemStackHandler"));
        } else if (nbt.func_74764_b("ItemStackHandler")) {
            CompoundNBT handlerTag = nbt.func_74775_l("ItemStackHandler");
            ListNBT tagList = handlerTag.func_150295_c("Items", 10);
            this.upgradeHandler.setSize(1);
            int size = handlerTag.func_74762_e("Size");
            if (size == 4) {
                this.handler.setSize(3);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundNBT itemTags = tagList.func_150305_b(i);
                    int slot = itemTags.func_74762_e("Slot");
                    if (slot < 0 || slot >= 4) continue;
                    if (slot == 3) {
                        this.upgradeHandler.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)itemTags));
                        continue;
                    }
                    this.handler.setStackInSlot(slot, ItemStack.func_199557_a((CompoundNBT)itemTags));
                }
            } else {
                this.handler.deserializeNBT(handlerTag);
                this.upgradeHandler.setStackInSlot(0, ItemStack.field_190927_a);
            }
        } else {
            ListNBT listnbt = nbt.func_150295_c("Items", 10);
            this.handler.setSize(3);
            this.upgradeHandler.setSize(1);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.func_70302_i_()) continue;
                if (j == 3) {
                    this.upgradeHandler.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
                    continue;
                }
                this.handler.setStackInSlot(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
            }
        }
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.burnSpeed = nbt.func_74762_e("BurnSpeed");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.burnTimeTotal = nbt.func_74764_b("BurnTimeTotal") ? nbt.func_74762_e("BurnTimeTotal") : this.getBurnTime(this.handler.getStackInSlot(1));
        this.cookSpeed = nbt.func_74762_e("CookSpeed");
        CompoundNBT compoundnbt = nbt.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("BurnSpeed", this.burnSpeed);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74768_a("BurnTimeTotal", this.burnTimeTotal);
        compound.func_74768_a("CookSpeed", this.cookSpeed);
        compound.func_218657_a("UpgradeHandler", (INBT)this.upgradeHandler.serializeNBT());
        compound.func_218657_a("ItemStackHandler", (INBT)this.handler.serializeNBT());
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.func_74768_a(recipeId.toString(), craftedAmount.intValue()));
        compound.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return compound;
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean dirty = false;
        if (this.isBurning() && this.canSmelt((IRecipe<?>)this.currentRecipe)) {
            int speed = this.getSpeed();
            if (this.burnSpeed != speed) {
                this.burnSpeed = speed;
            }
            this.burnTime -= this.burnSpeed;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.handler.getStackInSlot(1);
            if (this.isBurning() || !fuel.func_190926_b() && !this.handler.getStackInSlot(0).func_190926_b()) {
                AbstractCookingRecipe irecipe = this.getRecipe();
                boolean valid = this.canSmelt((IRecipe<?>)irecipe);
                if (!this.isBurning() && valid) {
                    this.burnTimeTotal = this.burnTime = this.getBurnTime(fuel);
                    if (this.isBurning()) {
                        dirty = true;
                        if (fuel.hasContainerItem()) {
                            this.handler.setStackInSlot(1, fuel.getContainerItem());
                        } else if (!fuel.func_190926_b()) {
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                this.handler.setStackInSlot(1, fuel.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && valid) {
                    int speed;
                    int n = speed = this.isEfficient() ? 4 : this.getSpeed();
                    if (this.cookSpeed != speed) {
                        this.cookSpeed = speed;
                    }
                    this.cookTime += this.cookSpeed;
                    if (this.cookTime >= this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.smelt((IRecipe<?>)irecipe);
                        dirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (wasBurning != this.isBurning()) {
                dirty = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipeIn) {
        if (!this.handler.getStackInSlot(0).func_190926_b() && recipeIn != null) {
            ItemStack recipeOutput = recipeIn.func_77571_b();
            if (recipeOutput.func_190926_b()) {
                return false;
            }
            ItemStack output = this.handler.getStackInSlot(2);
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(recipeOutput)) {
                return false;
            }
            if (output.func_190916_E() + recipeOutput.func_190916_E() <= this.func_70297_j_() && output.func_190916_E() + recipeOutput.func_190916_E() <= output.func_77976_d()) {
                return true;
            }
            return output.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
        }
        return false;
    }

    private void smelt(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = this.handler.getStackInSlot(0);
            List additionalBlacklist = new ArrayList();
            if (ConfigHandler.COMMON.furnaceOutputBlacklist.get() != null && !((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).isEmpty() && !((String)((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).get(0)).isEmpty()) {
                additionalBlacklist = (List)ConfigHandler.COMMON.furnaceOutputBlacklist.get();
            }
            if (recipe instanceof MultipleOutputFurnaceRecipe) {
                MultipleOutputFurnaceRecipe multipleRecipe = (MultipleOutputFurnaceRecipe)recipe;
                NonNullList<ItemStack> outputStacks = multipleRecipe.getRecipeOutputs();
                for (int i = 0; i < outputStacks.size(); ++i) {
                    ItemStack outputStack2 = ((ItemStack)outputStacks.get(i)).func_77946_l();
                    if (i <= 0 || multipleRecipe.getSecondaryChance() == 1.0f && !(this.field_145850_b.field_73012_v.nextFloat() > multipleRecipe.getSecondaryChance())) {
                        BiggestInventory inventory;
                        IItemHandler itemHandler;
                        ItemStack rest;
                        ArrayList<BiggestInventory> inventoryList = new ArrayList<BiggestInventory>();
                        for (Direction dir : Direction.values()) {
                            IItemHandler itemHandler2;
                            boolean flag2;
                            TileEntity foundTile;
                            BlockPos offPos = this.field_174879_c.func_177972_a(dir);
                            if (!this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) || (foundTile = this.field_145850_b.func_175625_s(offPos)) == null) continue;
                            ResourceLocation typeLocation = foundTile.func_200662_C().getRegistryName();
                            boolean flag = foundTile instanceof IHopper || foundTile instanceof AbstractFurnaceTileEntity || foundTile instanceof AbstractForceFurnaceTile;
                            boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                            if (flag || !flag2 || foundTile.func_145837_r() || !foundTile.func_145830_o() || !foundTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() || (itemHandler2 = (IItemHandler)foundTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).orElse(null)) == null) continue;
                            inventoryList.add(new BiggestInventory(offPos, itemHandler2.getSlots(), dir.func_176734_d()));
                        }
                        inventoryList.sort(Collections.reverseOrder());
                        Iterator iterator = inventoryList.iterator();
                        while (iterator.hasNext() && !(outputStack2 = (rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)iterator.next()).getIItemHandler(this.field_145850_b)), (ItemStack)outputStack2, (boolean)false))).func_190926_b()) {
                        }
                        if (i > 0 && !outputStack2.func_190926_b()) {
                            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p(), 1, 0.0, 0.0, 0.0, 0.0);
                            ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), outputStack2);
                            this.field_145850_b.func_217376_c((Entity)itemEntity);
                            continue;
                        }
                        ItemStack itemstack2 = this.handler.getStackInSlot(2);
                        if (itemstack2.func_190926_b() && !outputStack2.func_190926_b()) {
                            this.handler.setStackInSlot(2, outputStack2);
                            continue;
                        }
                        if (itemstack2.func_77973_b() != ((ItemStack)outputStacks.get(i)).func_77973_b()) continue;
                        itemstack2.func_190917_f(outputStack2.func_190916_E());
                        continue;
                    }
                    break;
                }
            } else {
                BiggestInventory inventory;
                IItemHandler itemHandler;
                ItemStack rest;
                ItemStack itemstack1 = recipe.func_77571_b();
                ItemStack outputStack = itemstack1.func_77946_l();
                ArrayList<BiggestInventory> inventoryList = new ArrayList<BiggestInventory>();
                for (Direction dir : Direction.values()) {
                    IItemHandler itemHandler3;
                    boolean flag2;
                    TileEntity foundTile;
                    BlockPos offPos = this.field_174879_c.func_177972_a(dir);
                    if (!this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) || (foundTile = this.field_145850_b.func_175625_s(offPos)) == null) continue;
                    ResourceLocation typeLocation = foundTile.func_200662_C().getRegistryName();
                    boolean flag = foundTile instanceof IHopper || foundTile instanceof AbstractFurnaceTileEntity || foundTile instanceof AbstractForceFurnaceTile;
                    boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                    if (flag || !flag2 || foundTile.func_145837_r() || !foundTile.func_145830_o() || !foundTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() || (itemHandler3 = (IItemHandler)foundTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).orElse(null)) == null) continue;
                    inventoryList.add(new BiggestInventory(offPos, itemHandler3.getSlots(), dir.func_176734_d()));
                }
                inventoryList.sort(Collections.reverseOrder());
                Iterator outputStack2 = inventoryList.iterator();
                while (outputStack2.hasNext() && !(outputStack = (rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)outputStack2.next()).getIItemHandler(this.field_145850_b)), (ItemStack)outputStack, (boolean)false))).func_190926_b()) {
                }
                ItemStack itemstack2 = this.handler.getStackInSlot(2);
                if (itemstack2.func_190926_b() && !outputStack.func_190926_b()) {
                    this.handler.setStackInSlot(2, outputStack);
                } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                    itemstack2.func_190917_f(outputStack.func_190916_E());
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !this.handler.getStackInSlot(1).func_190926_b() && this.handler.getStackInSlot(1).func_77973_b() == Items.field_151133_ar) {
                this.handler.setStackInSlot(1, new ItemStack((IItemProvider)Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    protected int getBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel);
    }

    protected int getCookTime() {
        AbstractCookingRecipe rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(this.getRecipeType(), (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(100);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.handler.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.handler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemHandlerUtils.getAndSplit((IItemHandler)this.handler, index, count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemHandlerUtils.getAndRemove((IItemHandler)this.handler, index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = this.handler.getStackInSlot(index);
        boolean flag = this.handler.isItemValid(index, stack) && !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.handler.setStackInSlot(index, stack);
        if (stack.func_190916_E() > this.handler.getSlotLimit(index)) {
            stack.func_190920_e(this.handler.getSlotLimit(index));
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.handler.isItemValid(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void unlockRecipes(PlayerEntity player) {
        List<IRecipe<?>> list = this.grantStoredRecipeExperience(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(list);
        this.recipes.clear();
    }

    public List<IRecipe<?>> grantStoredRecipeExperience(World world, Vector3d pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            world.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractForceFurnaceTile.splitAndSpawnExperience(world, pos, entry.getIntValue(), ((AbstractCookingRecipe)recipe).func_222138_b() * (float)this.getXPMultiplier());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(World world, Vector3d pos, int craftedAmount, float experience) {
        int i = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float f = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            helper.func_194112_a(this.handler.getStackInSlot(i));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
        this.handlerHolder.invalidate();
        this.upgradeHandlerHolder.invalidate();
    }

    public IIntArray getFurnaceData() {
        return this.furnaceData;
    }

    private class BiggestInventory
    implements Comparable<BiggestInventory> {
        private final int inventorySize;
        private final BlockPos tilePos;
        private final Direction direction;

        public BiggestInventory(BlockPos pos, int size, Direction dir) {
            this.tilePos = pos;
            this.inventorySize = size;
            this.direction = dir;
        }

        protected IItemHandler getIItemHandler(World world) {
            TileEntity tileEntity;
            if (world.isAreaLoaded(AbstractForceFurnaceTile.this.field_174879_c, 1) && !(tileEntity = world.func_175625_s(this.tilePos)).func_145837_r() && tileEntity.func_145830_o() && tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.direction).orElse(null);
            }
            return null;
        }

        @Override
        public int compareTo(BiggestInventory otherInventory) {
            return Integer.compare(this.inventorySize, otherInventory.inventorySize);
        }
    }
}

