/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.registry;

import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.entities.ChuChuEntity;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.CreeperTotEntity;
import com.mrbysco.forcecraft.entities.EnderTotEntity;
import com.mrbysco.forcecraft.entities.FairyEntity;
import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ForceEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"forcecraft");
    public static final RegistryObject<EntityType<NonBurnableItemEntity>> NON_BURNABLE_ITEM = ENTITIES.register("non_burnable_item", () -> ForceEntities.register("non_burnable_item", EntityType.Builder.func_220322_a(NonBurnableItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(6).func_233608_b_(20)));
    public static final RegistryObject<EntityType<ColdChickenEntity>> COLD_CHICKEN = ENTITIES.register("cold_chicken", () -> ForceEntities.register("cold_chicken", EntityType.Builder.func_220322_a(ColdChickenEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ColdCowEntity>> COLD_COW = ENTITIES.register("cold_cow", () -> ForceEntities.register("cold_cow", EntityType.Builder.func_220322_a(ColdCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ColdPigEntity>> COLD_PIG = ENTITIES.register("cold_pig", () -> ForceEntities.register("cold_pig", EntityType.Builder.func_220322_a(ColdPigEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<FairyEntity>> FAIRY = ENTITIES.register("fairy", () -> ForceEntities.register("fairy", EntityType.Builder.func_220322_a(FairyEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.5f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> RED_CHU_CHU = ENTITIES.register("red_chu_chu", () -> ForceEntities.register("red_chu_chu", EntityType.Builder.func_220322_a(ChuChuEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> GREEN_CHU_CHU = ENTITIES.register("green_chu_chu", () -> ForceEntities.register("green_chu_chu", EntityType.Builder.func_220322_a(ChuChuEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> BLUE_CHU_CHU = ENTITIES.register("blue_chu_chu", () -> ForceEntities.register("blue_chu_chu", EntityType.Builder.func_220322_a(ChuChuEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> GOLD_CHU_CHU = ENTITIES.register("gold_chu_chu", () -> ForceEntities.register("gold_chu_chu", EntityType.Builder.func_220322_a(ChuChuEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f).func_233606_a_(10)));
    public static final RegistryObject<EntityType<CreeperTotEntity>> CREEPER_TOT = ENTITIES.register("creeper_tot", () -> ForceEntities.register("creeper_tot", EntityType.Builder.func_220322_a(CreeperTotEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.1f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<EnderTotEntity>> ENDER_TOT = ENTITIES.register("ender_tot", () -> ForceEntities.register("ender_tot", EntityType.Builder.func_220322_a(EnderTotEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.6f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<AngryEndermanEntity>> ANGRY_ENDERMAN = ENTITIES.register("angry_enderman", () -> ForceEntities.register("angry_enderman", EntityType.Builder.func_220322_a(AngryEndermanEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.9f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<ForceArrowEntity>> FORCE_ARROW = ENTITIES.register("force_arrow", () -> ForceEntities.register("force_arrow", EntityType.Builder.func_220322_a(ForceArrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(4).func_233608_b_(20)));
    public static final RegistryObject<EntityType<FlaskEntity>> FORCE_FLASK = ENTITIES.register("force_flask", () -> ForceEntities.register("force_flask", EntityType.Builder.func_220322_a(FlaskEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setCustomClientFactory(FlaskEntity::new).func_233606_a_(4).func_233608_b_(10)));

    public static void registerSpawnPlacement() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)RED_CHU_CHU.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GREEN_CHU_CHU.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BLUE_CHU_CHU.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GOLD_CHU_CHU.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CREEPER_TOT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ENDER_TOT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)FAIRY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, FairyEntity::canSpawnOn);
    }

    public static void addSpawns(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
            if (((Boolean)ConfigHandler.COMMON.ChuChuSpawning.get()).booleanValue()) {
                if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)RED_CHU_CHU.get(), 1, 1, 1));
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)GREEN_CHU_CHU.get(), 1, 1, 1));
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)BLUE_CHU_CHU.get(), 1, 1, 1));
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)GOLD_CHU_CHU.get(), 1, 1, 1));
                }
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)RED_CHU_CHU.get(), ((Integer)ConfigHandler.COMMON.ChuChuWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMaxGroup.get()).intValue()));
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)GREEN_CHU_CHU.get(), ((Integer)ConfigHandler.COMMON.ChuChuWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMaxGroup.get()).intValue()));
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)BLUE_CHU_CHU.get(), ((Integer)ConfigHandler.COMMON.ChuChuWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMaxGroup.get()).intValue()));
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)GOLD_CHU_CHU.get(), ((Integer)ConfigHandler.COMMON.ChuChuWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.ChuChuMaxGroup.get()).intValue()));
            }
            if (((Boolean)ConfigHandler.COMMON.FairySpawning.get()).booleanValue()) {
                event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FAIRY.get(), ((Integer)ConfigHandler.COMMON.FairyWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.FairyMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.FairyMaxGroup.get()).intValue()));
            }
            if (((Boolean)ConfigHandler.COMMON.CreeperTotSpawning.get()).booleanValue()) {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)CREEPER_TOT.get(), ((Integer)ConfigHandler.COMMON.CreeperTotWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.CreeperTotMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.CreeperTotMaxGroup.get()).intValue()));
            }
            if (((Boolean)ConfigHandler.COMMON.EnderTotSpawning.get()).booleanValue()) {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ENDER_TOT.get(), ((Integer)ConfigHandler.COMMON.EnderTotWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.EnderTotMinGroup.get()).intValue(), ((Integer)ConfigHandler.COMMON.EnderTotMaxGroup.get()).intValue()));
            }
        }
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)COLD_CHICKEN.get(), ColdChickenEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)COLD_COW.get(), ColdCowEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)COLD_PIG.get(), ColdPigEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)RED_CHU_CHU.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)GREEN_CHU_CHU.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)BLUE_CHU_CHU.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)GOLD_CHU_CHU.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
        event.put((EntityType)CREEPER_TOT.get(), CreeperTotEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)ENDER_TOT.get(), EnderTotEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)ANGRY_ENDERMAN.get(), AngryEndermanEntity.generateAttributes().func_233813_a_());
        event.put((EntityType)FAIRY.get(), FairyEntity.generateAttributes().func_233813_a_());
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.func_206830_a(id);
    }
}

