/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrbysco.forcecraft.items.ExperienceTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ExperienceBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TransmutationRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final boolean isSimple;

    public TransmutationRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ForceRecipes.TRANSMUTATION_SERIALIZER.get();
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (itemstack.func_77973_b() instanceof ForceRodItem) {
                if (this.isSimple) {
                    recipeitemhelper.func_221264_a(itemstack, 1);
                    continue;
                }
                inputs.add(itemstack);
                continue;
            }
            if (itemstack.func_77973_b() instanceof ExperienceTomeItem) {
                if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74762_e("Experience") < 100) {
                    return false;
                }
                ItemStack experienceTome = new ItemStack((IItemProvider)ForceRegistry.EXPERIENCE_TOME.get());
                CompoundNBT nbt = experienceTome.func_196082_o();
                nbt.func_74768_a("Experience", 100);
                experienceTome.func_77982_d(nbt);
                if (this.isSimple) {
                    recipeitemhelper.func_221264_a(experienceTome, 1);
                    continue;
                }
                inputs.add(experienceTome);
                continue;
            }
            if (itemstack.func_77951_h()) continue;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack resultStack = this.recipeOutput.func_77946_l();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            Map enchantmentMap;
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_77973_b() instanceof ExperienceTomeItem) {
                CompoundNBT tag = itemstack.func_196082_o();
                int experience = tag.func_74762_e("Experience");
                int count = Math.min((int)((float)experience / 100.0f), 64);
                resultStack.func_190920_e(count);
            }
            if (!(itemstack.func_77973_b() instanceof EnchantedBookItem) || !(resultStack.func_77973_b() instanceof ExperienceBottleItem) || (enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemstack)).isEmpty()) continue;
            int amount = 0;
            for (Map.Entry entry : enchantmentMap.entrySet()) {
                amount += ((Integer)entry.getValue()).intValue();
            }
            resultStack.func_190920_e(MathHelper.func_76125_a((int)amount, (int)1, (int)64));
        }
        return resultStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.hasContainerItem()) {
                nonnulllist.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (itemstack.func_77973_b() instanceof ForceRodItem) {
                itemstack1 = itemstack.func_77946_l();
                ForceRodItem rod = (ForceRodItem)itemstack1.func_77973_b();
                int damage = rod.damageItem(itemstack1, 1);
                if (itemstack1.func_77973_b().getDamage(itemstack1) >= itemstack1.func_77958_k()) {
                    itemstack1.func_190918_g(1);
                    continue;
                }
                itemstack1.func_196085_b(itemstack1.func_77952_i() + damage);
                nonnulllist.set(i, (Object)itemstack1);
                continue;
            }
            if (!(itemstack.func_77973_b() instanceof ExperienceTomeItem)) continue;
            itemstack1 = itemstack.func_77946_l();
            CompoundNBT tag = itemstack.func_196082_o();
            int experience = tag.func_74762_e("Experience");
            int count = (int)((float)experience / 100.0f);
            int newExperience = count > 64 ? experience - 6400 : experience - count * 100;
            tag.func_74768_a("Experience", newExperience);
            itemstack1.func_77982_d(tag);
            nonnulllist.set(i, (Object)itemstack1);
        }
        return nonnulllist;
    }

    public static class SerializerTransmutationRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TransmutationRecipe> {
        public TransmutationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = SerializerTransmutationRecipe.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new TransmutationRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public TransmutationRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new TransmutationRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(PacketBuffer buffer, TransmutationRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

