/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedNoRemainderRecipe
extends ShapedRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final String group;

    public ShapedNoRemainderRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ForceRecipes.SHAPED_NO_REMAINDER_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        return nonnulllist;
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, ShapedNoRemainderRecipe.firstNonSpace(s));
            int j1 = ShapedNoRemainderRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + s + "'");
        }
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    public static class SerializerShapedNoRemainderRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedNoRemainderRecipe> {
        public ShapedNoRemainderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedNoRemainderRecipe.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = ShapedNoRemainderRecipe.shrink(ShapedNoRemainderRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = ShapedNoRemainderRecipe.deserializeIngredients(astring, map, i, j);
            ItemStack itemstack = ShapedNoRemainderRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapedNoRemainderRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public ShapedNoRemainderRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapedNoRemainderRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(PacketBuffer buffer, ShapedNoRemainderRecipe recipe) {
            buffer.func_150787_b(recipe.recipeWidth);
            buffer.func_150787_b(recipe.recipeHeight);
            buffer.func_180714_a(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

