/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blocks.infuser.InfuserModifierType;
import com.mrbysco.forcecraft.blocks.infuser.InfuserTileEntity;
import com.mrbysco.forcecraft.capablilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfuseRecipe
implements IRecipe<InfuserTileEntity> {
    private static final int MAX_SLOTS = 8;
    private static final Set<String> HASHES = new HashSet<String>();
    public static final Map<Integer, List<InfuseRecipe>> RECIPESBYLEVEL = new HashMap<Integer, List<InfuseRecipe>>();
    private final ResourceLocation id;
    public Ingredient input = Ingredient.field_193370_a;
    public InfuserModifierType resultModifier;
    ItemStack output = ItemStack.field_190927_a;
    private UpgradeBookTier tier;
    private Ingredient center;
    private int time;

    public InfuseRecipe(ResourceLocation id, Ingredient center, Ingredient input, InfuserModifierType result, UpgradeBookTier tier, ItemStack outputStack) {
        this.id = id;
        this.input = input;
        this.center = center;
        this.output = outputStack;
        this.resultModifier = result;
        this.setTier(tier);
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean matches(InfuserTileEntity inv, World worldIn) {
        for (int i = 0; i < inv.handler.getSlots(); ++i) {
            ItemStack stack = inv.handler.getStackInSlot(i);
            if (i >= 8) continue;
            return this.matchesModifier(inv, stack, false);
        }
        return false;
    }

    public boolean matchesModifier(InfuserTileEntity inv, ItemStack modifier, boolean ignoreInfused) {
        UpgradeBookData bd = new UpgradeBookData(inv.getBookInSlot());
        int bookTier = bd.getTier().ordinal();
        if (this.getTier().ordinal() > bookTier) {
            return false;
        }
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        boolean toolMatches = this.matchesTool(centerStack, ignoreInfused);
        boolean modifierMatches = this.matchesModifier(centerStack, modifier);
        return toolMatches && modifierMatches;
    }

    public boolean matchesModifier(InfuserTileEntity inv, ItemStack modifierStack) {
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        return this.matchesModifier(centerStack, modifierStack);
    }

    public boolean matchesModifier(ItemStack centerStack, ItemStack modifierStack) {
        IItemHandler handler;
        if (modifierStack.func_77973_b() == ForceRegistry.FORCE_PACK_UPGRADE.get() && (handler = (IItemHandler)centerStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) instanceof PackItemStackHandler && ((PackItemStackHandler)handler).getUpgrades() != this.getTier().ordinal() - 2) {
            return false;
        }
        return this.input.test(modifierStack);
    }

    public boolean matchesTool(ItemStack toolStack, boolean ignoreInfused) {
        if (!this.center.test(toolStack)) {
            return false;
        }
        return ignoreInfused || !toolStack.func_77942_o() || !toolStack.func_77978_p().func_74767_n("ForceInfused");
    }

    public boolean func_194133_a(int width, int height) {
        return height == 1 && width < 8;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean hasOutput() {
        return !this.output.func_190926_b();
    }

    public ItemStack assemble(InfuserTileEntity inv) {
        return this.func_77571_b();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeType<?> func_222127_g() {
        return ForceRecipes.INFUSER_TYPE;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getCenter() {
        return this.center;
    }

    public InfuserModifierType getModifier() {
        return this.resultModifier;
    }

    public void setModifier(InfuserModifierType modifier) {
        this.resultModifier = modifier;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.center);
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ForceRecipes.INFUSER_SERIALIZER.get();
    }

    public static boolean addRecipe(InfuseRecipe recipe) {
        ResourceLocation id = recipe.func_199560_c();
        if (HASHES.contains(id.toString())) {
            return false;
        }
        int thisTier = recipe.getTier().ordinal();
        if (!RECIPESBYLEVEL.containsKey(thisTier)) {
            RECIPESBYLEVEL.put(thisTier, new ArrayList());
        }
        RECIPESBYLEVEL.get(thisTier).add(recipe);
        HASHES.add(id.toString());
        ForceCraft.LOGGER.info("Recipe loaded {} -> {} , {}", (Object)id.toString(), (Object)recipe.resultModifier, (Object)recipe.input.func_200304_c());
        return true;
    }

    public static class SerializeInfuserRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfuseRecipe> {
        public InfuseRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            InfuseRecipe recipe = null;
            try {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
                Ingredient center = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"center"));
                String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                InfuserModifierType modifier = InfuserModifierType.valueOf(result.replace("forcecraft:", "").toUpperCase());
                ItemStack output = ItemStack.field_190927_a;
                if (modifier == InfuserModifierType.ITEM && JSONUtils.func_151204_g((JsonObject)json, (String)"output")) {
                    output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
                }
                int tier = JSONUtils.func_151203_m((JsonObject)json, (String)"tier");
                recipe = new InfuseRecipe(recipeId, center, ingredient, modifier, UpgradeBookTier.values()[tier], output);
                recipe.setTime(JSONUtils.func_151203_m((JsonObject)json, (String)"time"));
                InfuseRecipe.addRecipe(recipe);
                return recipe;
            }
            catch (Exception e) {
                ForceCraft.LOGGER.error("Error loading recipe " + recipeId, (Throwable)e);
                return null;
            }
        }

        public InfuseRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient center = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ing = Ingredient.func_199566_b((PacketBuffer)buffer);
            int enumlon = buffer.func_150792_a();
            int tier = buffer.readInt();
            InfuseRecipe r = new InfuseRecipe(recipeId, center, ing, InfuserModifierType.values()[enumlon], UpgradeBookTier.values()[tier], buffer.func_150791_c());
            r.setTime(buffer.readInt());
            InfuseRecipe.addRecipe(r);
            return r;
        }

        public void toNetwork(PacketBuffer buffer, InfuseRecipe recipe) {
            recipe.center.func_199564_a(buffer);
            recipe.input.func_199564_a(buffer);
            buffer.func_150787_b(recipe.resultModifier.ordinal());
            buffer.writeInt(recipe.getTier().ordinal());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.writeInt(recipe.getTime());
        }
    }
}

