/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GrindingRecipe
extends MultipleOutputFurnaceRecipe {
    public GrindingRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float chance, float experienceIn, int cookTimeIn) {
        super(ForceRecipes.GRINDING, idIn, groupIn, ingredientIn, results, chance, experienceIn, cookTimeIn);
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ForceRegistry.GRINDING_CORE.get());
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ForceRecipes.GRINDING_SERIALIZER.get();
    }

    public static class SerializerGrindingRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GrindingRecipe> {
        public GrindingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            if (!json.has("results")) {
                throw new JsonSyntaxException("Missing results, expected to find a string or object");
            }
            NonNullList<ItemStack> nonnulllist = SerializerGrindingRecipe.readItemStacks(JSONUtils.func_151214_t((JsonObject)json, (String)"results"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No results for grinding recipe");
            }
            if (nonnulllist.size() > MultipleOutputFurnaceRecipe.MAX_OUTPUT) {
                throw new JsonParseException("Too many results for grinding recipe the max is " + MultipleOutputFurnaceRecipe.MAX_OUTPUT);
            }
            float chance = JSONUtils.func_151221_a((JsonObject)json, (String)"secondaryChance", (float)0.0f);
            float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int i = JSONUtils.func_151208_a((JsonObject)json, (String)"processtime", (int)200);
            return new GrindingRecipe(recipeId, s, ingredient, nonnulllist, chance, f, i);
        }

        private static NonNullList<ItemStack> readItemStacks(JsonArray resultArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < resultArray.size(); ++i) {
                if (!resultArray.get(i).isJsonObject()) continue;
                ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)resultArray.get(i).getAsJsonObject());
                nonnulllist.add((Object)stack);
            }
            return nonnulllist;
        }

        @Nullable
        public GrindingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int size = buffer.func_150792_a();
            NonNullList resultList = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)buffer.func_150791_c());
            }
            float chance = buffer.readFloat();
            float f = buffer.readFloat();
            int i = buffer.func_150792_a();
            return new GrindingRecipe(recipeId, s, ingredient, (NonNullList<ItemStack>)resultList, chance, f, i);
        }

        public void toNetwork(PacketBuffer buffer, GrindingRecipe recipe) {
            buffer.func_180714_a(recipe.field_222141_c);
            recipe.field_222142_d.func_199564_a(buffer);
            buffer.func_150787_b(recipe.resultItems.size());
            for (ItemStack stack : recipe.resultItems) {
                buffer.func_150788_a(stack);
            }
            buffer.writeFloat(recipe.secondaryChance);
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
        }
    }
}

